/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import com.olekdia.androidcommon.extensions.CompatExt;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.androidcommon.extensions.ResExt;
import com.olekdia.datetimepickers.DTPickersHelper;
import com.olekdia.datetimepickers.R;
import com.olekdia.datetimepickers.calendars.CalendarCompat;
import com.olekdia.datetimepickers.date.IDatePickerController;
import com.olekdia.datetimepickers.date.MonthAdapter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public abstract class MonthView
extends View {
    protected static int DEFAULT_HEIGHT = 32;
    protected static int MIN_HEIGHT = 10;
    protected static final int DEFAULT_NUM_ROWS = 6;
    protected static final int MAX_NUM_ROWS = 6;
    private static final int SELECTED_CIRCLE_ALPHA = 255;
    protected final int mDaySeparatorWidth = 1;
    protected final int mMiniDayNumberTextSize;
    protected final int mMonthLabelTextSize;
    protected final int mMonthDayLabelTextSize;
    protected final int mMonthHeaderSize;
    protected final int mDaySelectedCircleSize;
    protected IDatePickerController mController;
    protected int mEdgePadding = 0;
    protected Typeface mDefNormalTypeface;
    protected Typeface mDefBoldTypeface;
    protected Paint mMonthNumPaint;
    protected Paint mMonthTitlePaint;
    protected Paint mSelectedCirclePaint;
    protected Paint mMonthDayLabelPaint;
    protected int mMonth;
    protected int mYear;
    protected int mWidth;
    protected int mRowHeight = DEFAULT_HEIGHT;
    protected boolean mHasToday = false;
    protected int mSelectedDay = -1;
    protected int mToday = -1;
    protected int mWeekStart = 1;
    protected int mNumCells = 7;
    private int mDayOfWeekStart = 0;
    private final boolean mIsRtl;
    private final Calendar mCalendar;
    protected int mNumRows = 6;
    protected OnDayClickListener mOnDayClickListener;
    protected int mPrimaryTextColor;
    protected int mSelectedDayTextColor;
    protected int mSecondaryTextColor;
    protected int mHighlightedDayTextColor;
    protected int mDisabledDayTextColor;
    protected int mMonthTitleColor;
    private SimpleDateFormat mFormatter;

    public MonthView(Context context) {
        this(context, null, null);
    }

    public MonthView(Context context, AttributeSet attr2, IDatePickerController controller) {
        super(context, attr2);
        boolean darkTheme;
        this.mController = controller;
        Resources res = context.getResources();
        this.mCalendar = CalendarCompat.getInstance();
        this.mDefNormalTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
        this.mDefBoldTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)1);
        this.mIsRtl = LocaleExt.isLayoutRtl((Resources)res);
        String pattern = CompatExt.getBestDateTimePattern((Locale)Locale.getDefault(), (String)"LLLL yyyy");
        this.mFormatter = new SimpleDateFormat(pattern, Locale.getDefault());
        this.mFormatter.applyLocalizedPattern(pattern);
        boolean bl = darkTheme = this.mController != null && this.mController.isThemeDark();
        if (darkTheme) {
            this.mPrimaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_normal_dark_theme);
            this.mSecondaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_month_day_dark_theme);
            this.mDisabledDayTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_disabled_dark_theme);
            this.mHighlightedDayTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_highlighted_dark_theme);
        } else {
            this.mPrimaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_normal);
            this.mSecondaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_month_day);
            this.mDisabledDayTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_disabled);
            this.mHighlightedDayTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_highlighted);
        }
        this.mSelectedDayTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_white);
        this.mMonthTitleColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_white);
        this.mMiniDayNumberTextSize = res.getDimensionPixelSize(R.dimen.mdtp_day_number_size);
        this.mMonthLabelTextSize = res.getDimensionPixelSize(R.dimen.mdtp_month_label_size);
        this.mMonthDayLabelTextSize = res.getDimensionPixelSize(R.dimen.mdtp_month_day_label_text_size);
        this.mMonthHeaderSize = res.getDimensionPixelOffset(R.dimen.mdtp_month_list_item_header_height);
        this.mDaySelectedCircleSize = res.getDimensionPixelSize(R.dimen.mdtp_day_number_select_circle_radius);
        this.mRowHeight = (res.getDimensionPixelOffset(R.dimen.mdtp_date_picker_view_animator_height) - this.getMonthHeaderSize()) / 6;
        this.initView();
    }

    public void setDatePickerController(IDatePickerController controller) {
        this.mController = controller;
    }

    public void setOnDayClickListener(OnDayClickListener listener) {
        this.mOnDayClickListener = listener;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                int day = this.getDayFromLocation(event.getX(), event.getY());
                if (day < 0) break;
                this.onDayClick(day);
            }
        }
        return true;
    }

    protected void initView() {
        Typeface boldFont = Typeface.create((String)this.getContext().getResources().getString(R.string.mdtp_sans_serif), (int)1);
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setTextSize((float)this.mMonthLabelTextSize);
        this.mMonthTitlePaint.setTypeface(boldFont);
        this.mMonthTitlePaint.setColor(this.mPrimaryTextColor);
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint = new Paint();
        this.mSelectedCirclePaint.setFakeBoldText(true);
        this.mSelectedCirclePaint.setAntiAlias(true);
        this.mSelectedCirclePaint.setColor(this.mController.getAccentColor());
        this.mSelectedCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedCirclePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint.setAlpha(255);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mMonthDayLabelPaint.setTextSize((float)this.mMonthDayLabelTextSize);
        this.mMonthDayLabelPaint.setColor(this.mSecondaryTextColor);
        this.mMonthDayLabelPaint.setTypeface(boldFont);
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthNumPaint = new Paint();
        this.mMonthNumPaint.setAntiAlias(true);
        this.mMonthNumPaint.setTextSize((float)this.mMiniDayNumberTextSize);
        this.mMonthNumPaint.setStyle(Paint.Style.FILL);
        this.mMonthNumPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthNumPaint.setFakeBoldText(false);
    }

    protected void onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawMonthDayLabels(canvas);
        this.drawMonthNums(canvas);
    }

    public void setMonthParams(int year, int month, int weekStart, int selectedDay) {
        this.mSelectedDay = selectedDay;
        this.mYear = year;
        this.mMonth = month;
        Calendar today = CalendarCompat.getInstance();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = weekStart != -1 ? weekStart : this.mCalendar.getFirstDayOfWeek();
        this.mNumCells = this.mCalendar.getActualMaximum(5);
        for (int i = 0; i < this.mNumCells; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mHasToday = true;
            this.mToday = day;
        }
        this.mNumRows = this.calculateNumRows();
    }

    public void setSelectedDay(int day) {
        this.mSelectedDay = day;
    }

    public void reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    private int calculateNumRows() {
        int offset = this.findDayOffset();
        int dividend = (offset + this.mNumCells) / 7;
        int remainder = (offset + this.mNumCells) % 7;
        return dividend + (remainder > 0 ? 1 : 0);
    }

    private boolean sameDay(int day, Calendar today) {
        return this.mYear == today.get(1) && this.mMonth == today.get(2) && day == today.get(5);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int bottomPadding = this.getContext().getResources().getDimensionPixelSize(R.dimen.mdtp_date_picker_bottom_padding);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mRowHeight * this.mNumRows + this.getMonthHeaderSize() + bottomPadding);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getYear() {
        return this.mYear;
    }

    protected int getMonthHeaderSize() {
        return this.mMonthHeaderSize;
    }

    @NonNull
    private String getMonthAndYearString() {
        return this.mFormatter.format(this.mCalendar.getTime());
    }

    protected void drawMonthTitle(Canvas canvas) {
        int x = (this.mWidth + 2 * this.mEdgePadding) / 2;
        int y = (this.getMonthHeaderSize() - this.mMonthDayLabelTextSize) / 2;
        canvas.drawText(this.getMonthAndYearString(), (float)x, (float)y, this.mMonthTitlePaint);
    }

    protected void drawMonthDayLabels(Canvas canvas) {
        int y = this.getMonthHeaderSize() - this.mMonthDayLabelTextSize / 2;
        int dayWidthHalf = (this.mWidth - this.mEdgePadding * 2) / 14;
        int todayInWeekIndex = (this.mDayOfWeekStart - this.mWeekStart + this.mToday - 1) % 7;
        for (int i = 0; i < 7; ++i) {
            boolean isToday;
            int x = (2 * i + 1) * dayWidthHalf + this.mEdgePadding;
            if (this.mIsRtl) {
                x = this.mWidth - x;
            }
            int dayInWeekIndex = DTPickersHelper.indexDayToShiftedWeekIndexDay(i, this.mWeekStart);
            boolean bl = isToday = this.mHasToday && todayInWeekIndex == i;
            if (isToday) {
                this.mMonthDayLabelPaint.setColor(this.mPrimaryTextColor);
            }
            canvas.drawText(this.getWeekDayLabel(dayInWeekIndex), (float)x, (float)y, this.mMonthDayLabelPaint);
            if (!isToday) continue;
            this.mMonthDayLabelPaint.setColor(this.mSecondaryTextColor);
        }
    }

    protected void drawMonthNums(Canvas canvas) {
        int y = (this.mRowHeight + this.mMiniDayNumberTextSize) / 2 - 1 + this.getMonthHeaderSize();
        float dayWidthHalf = (float)(this.mWidth - this.mEdgePadding * 2) / 14.0f;
        int j = this.findDayOffset();
        for (int dayNumber = 1; dayNumber <= this.mNumCells; ++dayNumber) {
            int x = (int)((float)(2 * j + 1) * dayWidthHalf + (float)this.mEdgePadding);
            if (this.mIsRtl) {
                x = this.mWidth - x;
            }
            int yRelativeToDay = (this.mRowHeight + this.mMiniDayNumberTextSize) / 2 - 1;
            int startX = (int)((float)x - dayWidthHalf);
            int stopX = (int)((float)x + dayWidthHalf);
            int startY = y - yRelativeToDay;
            int stopY = startY + this.mRowHeight;
            this.drawMonthDay(canvas, this.mYear, this.mMonth, dayNumber, x, y, startX, stopX, startY, stopY);
            if (++j != 7) continue;
            j = 0;
            y += this.mRowHeight;
        }
    }

    public abstract void drawMonthDay(Canvas var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    protected int findDayOffset() {
        return (this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + 7 : this.mDayOfWeekStart) - this.mWeekStart;
    }

    public int getDayFromLocation(float x, float y) {
        int day = this.getInternalDayFromLocation(x, y);
        if (day < 1 || day > this.mNumCells) {
            return -1;
        }
        return day;
    }

    protected int getInternalDayFromLocation(float x, float y) {
        int dayStart = this.mEdgePadding;
        if (x < (float)dayStart || x > (float)(this.mWidth - this.mEdgePadding)) {
            return -1;
        }
        int row = (int)(y - (float)this.getMonthHeaderSize()) / this.mRowHeight;
        int column = (int)((x - (float)dayStart) * 7.0f / (float)(this.mWidth - dayStart - this.mEdgePadding));
        if (this.mIsRtl) {
            column = 6 - column;
        }
        int day = column - this.findDayOffset() + 1;
        return day += row * 7;
    }

    private void onDayClick(int day) {
        if (this.mController.isOutOfRange(this.mYear, this.mMonth, day)) {
            return;
        }
        if (this.mOnDayClickListener != null) {
            this.mOnDayClickListener.onDayClick(this, new MonthAdapter.CalendarDay(this.mYear, this.mMonth, day));
        }
    }

    protected boolean isHighlighted(int year, int month, int day) {
        Calendar[] highlightedDays = this.mController.getHighlightedDays();
        if (highlightedDays == null) {
            return false;
        }
        for (Calendar c : highlightedDays) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            if (month < c.get(2)) break;
            if (month > c.get(2)) continue;
            if (day < c.get(5)) break;
            if (day > c.get(5)) continue;
            return true;
        }
        return false;
    }

    private String getWeekDayLabel(int dayInWeekIndex) {
        return this.mController.getDaysOfWeek()[dayInWeekIndex + 1];
    }

    public static interface OnDayClickListener {
        public void onDayClick(MonthView var1, MonthAdapter.CalendarDay var2);
    }
}

