/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.date;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.olekdia.datetimepickers.IOnDateChangedListener;
import com.olekdia.datetimepickers.date.IDatePickerController;
import com.olekdia.datetimepickers.date.MonthAdapter;
import com.olekdia.datetimepickers.date.MonthView;

public class DayPickerView
extends ListView
implements AbsListView.OnScrollListener,
IOnDateChangedListener {
    protected static final int GOTO_SCROLL_DURATION = 250;
    protected static final int SCROLL_CHANGE_DELAY = 40;
    public static int LIST_TOP_OFFSET = -1;
    protected float mFriction = 1.0f;
    protected Context mContext;
    protected Handler mHandler;
    protected MonthAdapter.CalendarDay mSelectedDay = new MonthAdapter.CalendarDay();
    protected MonthAdapter mAdapter;
    protected MonthAdapter.CalendarDay mTempDay = new MonthAdapter.CalendarDay();
    protected int mCurrentMonthDisplayed;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    protected int mCurrentScrollState = 0;
    private IDatePickerController mController;
    protected ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();

    public DayPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DayPickerView(Context context, IDatePickerController controller) {
        super(context);
        this.init(context);
        this.setController(controller);
    }

    public void setController(IDatePickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.refreshAdapter();
        this.onDateChanged();
    }

    public void init(Context context) {
        this.mHandler = new Handler();
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.mContext = context;
        this.setUpListView();
    }

    public void onChange() {
        this.refreshAdapter();
    }

    protected void refreshAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = this.createMonthAdapter(this.getContext(), this.mController);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public MonthAdapter createMonthAdapter(Context context, IDatePickerController controller) {
        return new MonthAdapter(context, controller);
    }

    protected void setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFriction(ViewConfiguration.getScrollFriction() * this.mFriction);
    }

    public boolean goTo(MonthAdapter.CalendarDay day, boolean animate, boolean setSelected, boolean forceScroll) {
        View child;
        if (setSelected) {
            this.mSelectedDay.set(day);
        }
        this.mTempDay.set(day);
        int minMonth = this.mController.getStartDate().get(2);
        int position = (day.year - this.mController.getMinYear()) * 12 + day.month - minMonth;
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null && (top = child.getTop()) < 0) {
        }
        int selectedPosition = child != null ? this.getPositionForView(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.smoothScrollToPositionFromTop(position, LIST_TOP_OFFSET, 250);
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    public void postSetSelection(final int position) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                DayPickerView.this.setSelection(position);
            }
        });
        this.onScrollStateChanged((AbsListView)this, 0);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        long currScroll;
        MonthView child = (MonthView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        this.mPreviousScrollPosition = currScroll = (long)(view.getFirstVisiblePosition() * child.getHeight() - child.getBottom());
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    protected void setMonthDisplayed(MonthAdapter.CalendarDay date) {
        this.mCurrentMonthDisplayed = date.month;
        this.invalidateViews();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    public int getMostVisiblePosition() {
        View child;
        int firstPosition = this.getFirstVisiblePosition();
        int height = this.getHeight();
        int maxDisplayedHeight = 0;
        int mostVisibleIndex = 0;
        int i = 0;
        int bottom = 0;
        while (bottom < height && (child = this.getChildAt(i)) != null) {
            bottom = child.getBottom();
            int displayedHeight = Math.min(bottom, height) - Math.max(0, child.getTop());
            if (displayedHeight > maxDisplayedHeight) {
                mostVisibleIndex = i;
                maxDisplayedHeight = displayedHeight;
            }
            ++i;
        }
        return firstPosition + mostVisibleIndex;
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    protected class ScrollStateRunnable
    implements Runnable {
        private int mNewState;

        protected ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            DayPickerView.this.mHandler.removeCallbacks((Runnable)this);
            this.mNewState = scrollState;
            DayPickerView.this.mHandler.postDelayed((Runnable)this, 40L);
        }

        @Override
        public void run() {
            DayPickerView.this.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && DayPickerView.this.mPreviousScrollState != 0 && DayPickerView.this.mPreviousScrollState != 1) {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
                int i = 0;
                View child = DayPickerView.this.getChildAt(i);
                while (child != null && child.getBottom() <= 0) {
                    child = DayPickerView.this.getChildAt(++i);
                }
                if (child == null) {
                    return;
                }
                int firstPosition = DayPickerView.this.getFirstVisiblePosition();
                int lastPosition = DayPickerView.this.getLastVisiblePosition();
                boolean scroll = firstPosition != 0 && lastPosition != DayPickerView.this.getCount() - 1;
                int top = child.getTop();
                int bottom = child.getBottom();
                int midpoint = DayPickerView.this.getHeight() / 2;
                if (scroll && top < LIST_TOP_OFFSET) {
                    if (bottom > midpoint) {
                        DayPickerView.this.smoothScrollBy(top, 250);
                    } else {
                        DayPickerView.this.smoothScrollBy(bottom, 250);
                    }
                }
            } else {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
            }
        }
    }
}

