/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.date;

import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.olekdia.androidcommon.extensions.ColorExt;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.androidcommon.extensions.MathExt;
import com.olekdia.androidcommon.extensions.ResExt;
import com.olekdia.datetimepickers.DTPickersHelper;
import com.olekdia.datetimepickers.HapticFeedbackController;
import com.olekdia.datetimepickers.IKeyScheme;
import com.olekdia.datetimepickers.IOnDateChangedListener;
import com.olekdia.datetimepickers.PickerDialog;
import com.olekdia.datetimepickers.R;
import com.olekdia.datetimepickers.calendars.CalendarCompat;
import com.olekdia.datetimepickers.date.DateAnimator;
import com.olekdia.datetimepickers.date.DayPickerView;
import com.olekdia.datetimepickers.date.IDatePickerController;
import com.olekdia.datetimepickers.date.MonthAdapter;
import com.olekdia.datetimepickers.year.YearsPickerView;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;

public class DatePickerDialog
extends PickerDialog
implements View.OnClickListener,
IDatePickerController,
IKeyScheme {
    private static final int MONTH_AND_DAY_VIEW = 0;
    private final Calendar mCalendar = CalendarCompat.getInstance();
    private OnDateSetListener mCallBack;
    private HashSet<IOnDateChangedListener> mListeners = new HashSet();
    private DateAnimator mAnimator;
    private boolean mDelayAnimation = true;
    private TextView mDayOfWeekView;
    private LinearLayout mMonthAndDayView;
    private TextView mSelectedMonthTextView;
    private TextView mSelectedDayTextView;
    private TextView mYearView;
    private DayPickerView mDayPickerView;
    private YearsPickerView mYearsPickerView;
    private int mCurrentView = -1;
    private int mDefaultView = 0;
    private String[] mDaysOfWeek;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private int mMinYear = MathExt.roundTo((int)(this.mCalendar.get(1) - 100), (int)100);
    private int mMaxYear = MathExt.roundTo((int)(this.mCalendar.get(1) + 200), (int)100);
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar[] mHighlightedDays;
    private Calendar[] mSelectableDays;

    public static DatePickerDialog newInstance(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        DatePickerDialog dlg = new DatePickerDialog();
        dlg.initialize(callBack, year, monthOfYear, dayOfMonth);
        return dlg;
    }

    public void initialize(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
        this.mCalendar.set(5, dayOfMonth);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mCurrentView = -1;
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt("year"));
            this.mCalendar.set(2, savedInstanceState.getInt("month"));
            this.mCalendar.set(5, savedInstanceState.getInt("day"));
            this.mDefaultView = savedInstanceState.getInt("default_view");
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setToNearestDate(this.mCalendar);
        View view = inflater.inflate(R.layout.mdtp_date_picker_dialog, container, false);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mMonthAndDayView = (LinearLayout)view.findViewById(R.id.date_picker_month_and_day);
        this.mMonthAndDayView.setOnClickListener((View.OnClickListener)this);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.date_picker_month);
        this.mSelectedDayTextView = (TextView)view.findViewById(R.id.date_picker_day);
        this.mYearView = (TextView)view.findViewById(R.id.date_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = this.mDefaultView;
        if (savedInstanceState != null) {
            this.mWeekStart = savedInstanceState.getInt("week_start");
            this.mDaysOfWeek = savedInstanceState.getStringArray("days_of_week");
            this.mMinYear = savedInstanceState.getInt("year_start");
            this.mMaxYear = savedInstanceState.getInt("year_end");
            currentView = savedInstanceState.getInt("current_view");
            listPosition = savedInstanceState.getInt("list_position");
            listPositionOffset = savedInstanceState.getInt("list_position_offset");
            this.mMinDate = (Calendar)savedInstanceState.getSerializable("min_date");
            this.mMaxDate = (Calendar)savedInstanceState.getSerializable("max_date");
            this.mHighlightedDays = (Calendar[])savedInstanceState.getSerializable("highlighted_days");
            this.mSelectableDays = (Calendar[])savedInstanceState.getSerializable("selectable_days");
            this.mDefaultView = savedInstanceState.getInt("default_view");
            this.restoreInstanceState(savedInstanceState);
        }
        FragmentActivity activity = this.getActivity();
        this.mDayPickerView = new DayPickerView((Context)activity, this);
        this.mYearsPickerView = new YearsPickerView((Context)activity, this);
        if (!this.mThemeDarkChanged) {
            this.mThemeDark = DTPickersHelper.isDarkTheme((Context)activity, this.mThemeDark);
        }
        if (this.mDaysOfWeek == null) {
            this.createDaysOfWeek();
        }
        int bgColorResource = this.mThemeDark ? R.color.mdtp_date_picker_view_animator_dark_theme : R.color.mdtp_date_picker_view_animator;
        view.setBackgroundColor(ResExt.getColorCompat((Context)activity, (int)bgColorResource));
        this.mAnimator = (DateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearsPickerView);
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        TextView okButton = (TextView)view.findViewById(R.id.ok);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                DatePickerDialog.this.notifyOnDateListener();
                DatePickerDialog.this.dismiss();
            }
        });
        if (this.mOkString != null) {
            okButton.setText((CharSequence)this.mOkString);
        } else {
            okButton.setText(this.mOkResId);
        }
        TextView cancelButton = (TextView)view.findViewById(R.id.cancel);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                if (DatePickerDialog.this.getDialog() != null) {
                    DatePickerDialog.this.getDialog().cancel();
                }
            }
        });
        if (this.mCancelString != null) {
            cancelButton.setText((CharSequence)this.mCancelString);
        } else {
            cancelButton.setText(this.mCancelResId);
        }
        cancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        if (this.mAccentColor == -1) {
            this.mAccentColor = DTPickersHelper.getAccentColorFromThemeIfAvailable((Context)activity);
        }
        if (this.mPrimaryColor == -1) {
            this.mPrimaryColor = DTPickersHelper.getPrimaryColorFromThemeIfAvailable((Context)activity);
        }
        okButton.setTextColor(this.mAccentColor);
        cancelButton.setTextColor(this.mAccentColor);
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setBackgroundColor(ColorExt.toDarkerColor((int)this.mPrimaryColor, (float)0.8f));
        }
        view.findViewById(R.id.day_picker_selected_date_layout).setBackgroundColor(this.mPrimaryColor);
        if (this.getDialog() == null) {
            view.findViewById(R.id.done_background).setVisibility(8);
        }
        this.updateDisplay();
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (currentView == 1) {
                this.mYearsPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        return view;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("year", this.mCalendar.get(1));
        outState.putInt("month", this.mCalendar.get(2));
        outState.putInt("day", this.mCalendar.get(5));
        outState.putInt("week_start", this.mWeekStart);
        outState.putStringArray("days_of_week", this.mDaysOfWeek);
        outState.putInt("year_start", this.mMinYear);
        outState.putInt("year_end", this.mMaxYear);
        outState.putInt("current_view", this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearsPickerView.getFirstVisiblePosition();
            outState.putInt("list_position_offset", this.mYearsPickerView.getFirstPositionOffset());
        }
        outState.putInt("list_position", listPosition);
        outState.putSerializable("min_date", (Serializable)this.mMinDate);
        outState.putSerializable("max_date", (Serializable)this.mMaxDate);
        outState.putSerializable("highlighted_days", (Serializable)this.mHighlightedDays);
        outState.putSerializable("selectable_days", (Serializable)this.mSelectableDays);
        outState.putInt("default_view", this.mDefaultView);
    }

    private void createDaysOfWeek() {
        Locale locale = Locale.getDefault();
        Calendar cal = CalendarCompat.getInstance();
        SimpleDateFormat dateFmt = new SimpleDateFormat("EEEEE", locale);
        this.mDaysOfWeek = new String[8];
        int firstDay = 2;
        for (int day = 1; day <= 7; ++day) {
            cal.set(7, firstDay);
            this.mDaysOfWeek[day] = dateFmt.format(cal.getTime());
            firstDay = firstDay % 7 + 1;
        }
    }

    private void setCurrentView(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                ObjectAnimator pulseAnimator = DTPickersHelper.getPulseAnimator((View)this.mMonthAndDayView, 0.9f, 1.05f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mYearView.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                break;
            }
            case 1: {
                ObjectAnimator pulseAnimator = DTPickersHelper.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearsPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(false);
                    this.mYearView.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
            }
        }
    }

    private void updateDisplay() {
        if (this.mDayOfWeekView != null) {
            if (this.mTitle != null) {
                this.mDayOfWeekView.setText((CharSequence)this.mTitle.toUpperCase(Locale.getDefault()));
            } else {
                this.mDayOfWeekView.setText((CharSequence)this.mCalendar.getDisplayName(7, 2, Locale.getDefault()).toUpperCase(Locale.getDefault()));
            }
        }
        this.mSelectedMonthTextView.setText((CharSequence)this.mCalendar.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mSelectedDayTextView.setText((CharSequence)LocaleExt.toLocal2DigNumerals((int)this.mCalendar.get(5), (int)this.mNumeralSystem));
        this.mYearView.setText((CharSequence)LocaleExt.toLocalNumerals((int)this.mCalendar.get(1), (int)this.mNumeralSystem));
    }

    private void updatePickers() {
        for (IOnDateChangedListener listener : this.mListeners) {
            listener.onDateChanged();
        }
    }

    private void adjustDayInMonthIfNeeded(Calendar calendar) {
        int daysInMonth;
        int day = calendar.get(5);
        if (day > (daysInMonth = calendar.getActualMaximum(5))) {
            calendar.set(5, daysInMonth);
        }
        this.setToNearestDate(calendar);
    }

    public void showYearPickerFirst(boolean yearPicker) {
        this.mDefaultView = yearPicker ? 1 : 0;
    }

    public void setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public final void setDaysOfWeek(String[] daysOfWeek) {
        this.mDaysOfWeek = daysOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear < startYear) {
            throw new IllegalArgumentException("Year end must be larger than or equal to year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = calendar;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = calendar;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setHighlightedDays(Calendar[] highlightedDays) {
        Arrays.sort(highlightedDays);
        this.mHighlightedDays = highlightedDays;
    }

    @Override
    public Calendar[] getHighlightedDays() {
        return this.mHighlightedDays;
    }

    public void setSelectableDays(Calendar[] selectableDays) {
        Arrays.sort(selectableDays);
        this.mSelectableDays = selectableDays;
    }

    @Override
    public Calendar[] getSelectableDays() {
        return this.mSelectableDays;
    }

    public void setOnDateSetListener(OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    @Override
    public MonthAdapter.CalendarDay getSelectedDay() {
        return new MonthAdapter.CalendarDay(this.mCalendar);
    }

    @Override
    public int getSelectedYear() {
        return this.mCalendar.get(1);
    }

    @Override
    public Calendar getStartDate() {
        if (this.mSelectableDays != null) {
            return this.mSelectableDays[0];
        }
        if (this.mMinDate != null) {
            return this.mMinDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMinYear);
        output.set(5, 1);
        output.set(2, 0);
        return output;
    }

    @Override
    public Calendar getEndDate() {
        if (this.mSelectableDays != null) {
            return this.mSelectableDays[this.mSelectableDays.length - 1];
        }
        if (this.mMaxDate != null) {
            return this.mMaxDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMaxYear);
        output.set(5, 31);
        output.set(2, 11);
        return output;
    }

    @Override
    public int getMinYear() {
        if (this.mSelectableDays != null) {
            return this.mSelectableDays[0].get(1);
        }
        return this.mMinDate != null && this.mMinDate.get(1) > this.mMinYear ? this.mMinDate.get(1) : this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        if (this.mSelectableDays != null) {
            return this.mSelectableDays[this.mSelectableDays.length - 1].get(1);
        }
        return this.mMaxDate != null && this.mMaxDate.get(1) < this.mMaxYear ? this.mMaxDate.get(1) : this.mMaxYear;
    }

    @Override
    public boolean isOutOfRange(int year, int month, int day) {
        if (this.mSelectableDays != null) {
            return !this.isSelectable(year, month, day);
        }
        if (this.isBeforeMin(year, month, day)) {
            return true;
        }
        return this.isAfterMax(year, month, day);
    }

    public boolean isOutOfRange(Calendar calendar) {
        return this.isOutOfRange(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private boolean isSelectable(int year, int month, int day) {
        for (Calendar c : this.mSelectableDays) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            if (month < c.get(2)) break;
            if (month > c.get(2)) continue;
            if (day < c.get(5)) break;
            if (day > c.get(5)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeforeMin(int year, int month, int day) {
        if (this.mMinDate == null) {
            return false;
        }
        if (year < this.mMinDate.get(1)) {
            return true;
        }
        if (year > this.mMinDate.get(1)) {
            return false;
        }
        if (month < this.mMinDate.get(2)) {
            return true;
        }
        if (month > this.mMinDate.get(2)) {
            return false;
        }
        return day < this.mMinDate.get(5);
    }

    private boolean isBeforeMin(Calendar calendar) {
        return this.isBeforeMin(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private boolean isAfterMax(int year, int month, int day) {
        if (this.mMaxDate == null) {
            return false;
        }
        if (year > this.mMaxDate.get(1)) {
            return true;
        }
        if (year < this.mMaxDate.get(1)) {
            return false;
        }
        if (month > this.mMaxDate.get(2)) {
            return true;
        }
        if (month < this.mMaxDate.get(2)) {
            return false;
        }
        return day > this.mMaxDate.get(5);
    }

    private boolean isAfterMax(Calendar calendar) {
        return this.isAfterMax(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private void setToNearestDate(Calendar calendar) {
        if (this.mSelectableDays != null) {
            long distance = Long.MAX_VALUE;
            Calendar currentBest = calendar;
            for (Calendar c : this.mSelectableDays) {
                long newDistance = Math.abs(calendar.getTimeInMillis() - c.getTimeInMillis());
                if (newDistance >= distance) break;
                distance = newDistance;
                currentBest = c;
            }
            calendar.setTimeInMillis(currentBest.getTimeInMillis());
            return;
        }
        if (this.isBeforeMin(calendar)) {
            calendar.setTimeInMillis(this.mMinDate.getTimeInMillis());
            return;
        }
        if (this.isAfterMax(calendar)) {
            calendar.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            return;
        }
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public String[] getDaysOfWeek() {
        return this.mDaysOfWeek;
    }

    @Override
    public void registerOnDateChangedListener(IOnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(IOnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    public void notifyOnDateListener() {
        if (this.mCallBack != null) {
            this.mCallBack.onDateSet(this, this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
        }
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.date_picker_year) {
            this.setCurrentView(1);
        } else if (v.getId() == R.id.date_picker_month_and_day) {
            this.setCurrentView(0);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.mCalendar.set(1, year);
        this.adjustDayInMonthIfNeeded(this.mCalendar);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay();
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay();
        if (this.mAutoDismiss) {
            this.notifyOnDateListener();
            this.dismiss();
        }
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePickerDialog var1, int var2, int var3, int var4);
    }
}

