/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.calendars;

import android.annotation.SuppressLint;
import com.olekdia.androidcommon.extensions.MathExt;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class PersianCalendar
extends Calendar {
    public static final int AH = 1;
    public static final int BH = 0;
    public static final int FARVARDIN = 0;
    public static final int ORDIBEHESHT = 1;
    public static final int KHORDAD = 2;
    public static final int TIR = 3;
    public static final int MORDAD = 4;
    public static final int SHAHRIVAR = 5;
    public static final int MEHR = 6;
    public static final int ABAN = 7;
    public static final int AZAR = 8;
    public static final int DEY = 9;
    public static final int BAHMAN = 10;
    public static final int ESFAND = 11;
    private static final int EPOCH_OFFSET = 492268;
    private static final int BASE_YEAR = 1349;
    private static final int[] FIXED_DATES = new int[]{492347, 492712, 493078, 493443, 493808, 494173, 494539, 494904, 495269, 495634, 496000, 496365, 496730, 497095, 497461, 497826, 498191, 498556, 498922, 499287, 499652, 500017, 500383, 500748, 501113, 501478, 501843, 502209, 502574, 502939, 503304, 503670, 504035, 504400, 504765, 505131, 505496, 505861, 506226, 506592, 506957, 507322, 507687, 508053, 508418, 508783, 509148, 509514, 509879, 510244, 510609, 510975, 511340, 511705, 512070, 512435, 512801, 513166, 513531, 513896, 514262, 514627, 514992, 515357, 515723, 516088, 516453, 516818, 517184};
    private static final int[] ACCUMULATED_DAYS_IN_MONTH = new int[]{0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336};
    private static final int[] MINIMUMS = new int[]{0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
    private static final int[] MAXIMUMS = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
    private static final int[] LEAST_MAXIMUMS = new int[]{1, 292269054, 11, 50, 3, 28, 355, 7, 3, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final long ONE_HOUR_IN_MILLIS = 3600000L;
    private static final long ONE_DAY_IN_MILLIS = 86400000L;
    private int fixedDate = 492268;

    public PersianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public PersianCalendar(int year, int month, int day) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(year, month, day);
    }

    public PersianCalendar(int year, int month, int day, int hour, int minute) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(year, month, day, hour, minute);
    }

    public PersianCalendar(int year, int month, int day, int hour, int minute, int second) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(year, month, day, hour, minute, second);
    }

    public PersianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public PersianCalendar(TimeZone timezone) {
        this(timezone, Locale.getDefault());
    }

    public PersianCalendar(TimeZone timezone, Locale locale) {
        super(timezone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    @Override
    public void add(int field, int value) {
        int offsetAfter;
        int offsetBefore;
        int dstDelta;
        if (value == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        if (field == 0) {
            this.complete();
            if (this.fields[0] == 1) {
                if (value >= 0) {
                    return;
                }
                this.set(0, 0);
            } else {
                if (value <= 0) {
                    return;
                }
                this.set(0, 1);
            }
            this.complete();
            return;
        }
        if (field == 1 || field == 2) {
            this.complete();
            if (field == 2) {
                int month = this.fields[2] + value;
                if (month < 0) {
                    value = (month - 11) / 12;
                    month = 12 + month % 12;
                } else {
                    value = month / 12;
                }
                this.set(2, month % 12);
            }
            this.set(1, this.fields[1] + value);
            int days = PersianCalendar.daysInMonth(PersianCalendar.isLeapYear(this.fields[1]), this.fields[2]);
            if (this.fields[5] > days) {
                this.set(5, days);
            }
            this.complete();
            return;
        }
        long multiplier = 0L;
        this.getTimeInMillis();
        switch (field) {
            case 14: {
                this.time += (long)value;
                break;
            }
            case 13: {
                this.time += (long)value * 1000L;
                break;
            }
            case 12: {
                this.time += (long)value * 60000L;
                break;
            }
            case 10: 
            case 11: {
                this.time += (long)value * 3600000L;
                break;
            }
            case 9: {
                multiplier = 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                multiplier = 86400000L;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                multiplier = 604800000L;
            }
        }
        if (multiplier == 0L) {
            this.areFieldsSet = false;
            this.complete();
            return;
        }
        long delta = (long)value * multiplier;
        int zoneOffset = this.getTimeZone().getRawOffset();
        if (this.getOffset(this.time + (long)zoneOffset + delta + (long)(dstDelta = (offsetBefore = this.getOffset(this.time + (long)zoneOffset)) - (offsetAfter = this.getOffset(this.time + (long)zoneOffset + delta)))) == offsetAfter) {
            delta += (long)dstDelta;
        }
        this.time += delta;
        this.areFieldsSet = false;
        this.complete();
    }

    @Override
    protected void computeFields() {
        int i;
        long timeInZone = this.time + (long)this.getOffset(this.time);
        this.fixedDate = (int)Math.floor((double)timeInZone * 1.0 / 8.64E7) + 492268;
        this.fields[1] = this.getYearFromFixedDate(this.fixedDate);
        if (this.fields[1] <= 0) {
            this.fields[1] = -this.fields[1] + 1;
            this.fields[0] = 0;
        } else {
            this.fields[0] = 1;
        }
        int year = this.fields[1];
        int far1 = PersianCalendar.getFixedDateFar1(year, this.fields[0] == 1);
        this.fields[6] = this.fixedDate - far1 + 1;
        this.fields[2] = this.fields[6] < ACCUMULATED_DAYS_IN_MONTH[6] ? (int)Math.floor((double)(this.fields[6] - 1) / 31.0) : (int)Math.floor((double)(this.fields[6] - 1 - ACCUMULATED_DAYS_IN_MONTH[6]) / 30.0) + 6;
        this.fields[5] = this.fields[6] - ACCUMULATED_DAYS_IN_MONTH[this.fields[2]];
        int dayOfWeek = year - 1376 + ACCUMULATED_DAYS_IN_MONTH[this.fields[2]] + this.fields[5] - 1;
        for (i = 1380; i < year; ++i) {
            if (!PersianCalendar.isLeapYear(i)) continue;
            ++dayOfWeek;
        }
        for (i = year; i < 1380; ++i) {
            if (!PersianCalendar.isLeapYear(i)) continue;
            --dayOfWeek;
        }
        if ((dayOfWeek %= 7) < 0) {
            dayOfWeek += 7;
        }
        this.fields[7] = dayOfWeek;
        long extra = timeInZone - (long)(this.fixedDate - 492268) * 86400000L;
        this.fields[11] = (int)Math.floor((double)extra * 1.0 / 3600000.0);
        if (this.fields[11] >= 12) {
            this.fields[10] = this.fields[11] - 12;
            this.fields[9] = 1;
        } else {
            this.fields[10] = this.fields[11] - 12;
            this.fields[9] = 0;
        }
        this.fields[12] = (int)Math.floor((double)(extra -= (long)this.fields[11] * 3600000L) * 1.0 / 60000.0);
        this.fields[13] = (int)Math.floor((double)(extra -= (long)this.fields[12] * 60000L) * 1.0 / 1000.0);
        this.fields[14] = (int)(extra -= (long)this.fields[13] * 1000L);
    }

    @Override
    protected void computeTime() {
        int extraYear;
        if (!this.isSet(1) || !this.isSet(2)) {
            return;
        }
        if (this.fields[1] == 0) {
            throw new IllegalArgumentException("Year cannot be zero");
        }
        if (!this.isSet(0)) {
            this.fields[0] = 1;
        }
        if ((extraYear = (int)Math.floor((double)this.fields[2] / 12.0)) != 0) {
            if (this.fields[0] == 1 ^ extraYear > 0) {
                if (this.fields[0] == 1 && this.fields[1] <= Math.abs(extraYear)) {
                    this.fields[1] = Math.abs(extraYear) - this.fields[1] + 1;
                    this.set(0, 0);
                } else if (this.fields[0] == 0 && this.fields[1] <= Math.abs(extraYear)) {
                    this.fields[1] = Math.abs(extraYear) - this.fields[1] + 1;
                    this.set(0, 1);
                } else {
                    this.fields[1] = this.fields[0] == 1 ? this.fields[1] + extraYear : this.fields[1] - extraYear;
                }
            } else {
                this.fields[1] = this.fields[1] + Math.abs(extraYear);
            }
        }
        this.fields[2] = this.fields[2] % 12;
        if (this.fields[2] < 0) {
            this.fields[2] = this.fields[2] + 12;
        }
        int fixedDate = PersianCalendar.getFixedDateFar1(this.fields[1], this.fields[0] == 1) + ACCUMULATED_DAYS_IN_MONTH[this.fields[2]] + (this.isSet(5) ? this.fields[5] - 1 : 0);
        int timezoneOffset = -this.getOffset((long)fixedDate * 86400000L);
        this.time = (long)(fixedDate - 492268) * 86400000L + 3600000L + (long)(this.isSet(11) ? this.fields[11] : (this.isSet(10) && this.isSet(9) ? this.fields[10] + (this.fields[9] == 0 ? 0 : 12) : 0)) * 3600000L + (long)(this.isSet(12) ? this.fields[12] : 0) * 60000L + (long)timezoneOffset + (long)(this.isSet(13) ? this.fields[13] : 0) * 1000L + (long)(this.isSet(14) ? this.fields[14] : 0);
        this.areFieldsSet = false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar cal = (Calendar)object;
        return this.getTimeInMillis() == cal.getTimeInMillis() && this.get(1) == cal.get(1) && this.get(2) == cal.get(2) && this.get(5) == cal.get(5) && this.get(10) == cal.get(10) && this.get(12) == cal.get(12) && this.get(13) == cal.get(13) && this.get(14) == cal.get(14);
    }

    @Override
    public int getActualMinimum(int field) {
        return this.getMinimum(field);
    }

    @Override
    public int getActualMaximum(int field) {
        switch (field) {
            case 5: {
                return this.daysInMonth();
            }
            case 6: {
                return this.daysInYear();
            }
        }
        return this.getMaximum(field);
    }

    @Override
    public int getGreatestMinimum(int field) {
        return MINIMUMS[field];
    }

    @Override
    public int getLeastMaximum(int field) {
        return LEAST_MAXIMUMS[field];
    }

    @Override
    public int getMaximum(int field) {
        return MAXIMUMS[field];
    }

    @Override
    public int getMinimum(int field) {
        return MINIMUMS[field];
    }

    @Override
    public void roll(int field, boolean increment) {
        throw new IllegalArgumentException("Not supported");
    }

    private int getOffset(long localTime) {
        return this.getTimeZone().getOffset(localTime);
    }

    private int getYearFromFixedDate(int fd) {
        boolean testAfterH = fd > 0;
        int testYear = testAfterH ? (int)Math.floor(Math.round((double)(fd - 1) / 365.24219)) + 1 : (int)Math.floor(Math.round((double)fd / 365.24219));
        if (testYear == 0) {
            testYear = 1;
            testAfterH = true;
        }
        if (PersianCalendar.getFixedDateFar1(Math.abs(testYear), testAfterH) <= fd) {
            return testYear <= 0 ? testYear + 1 : testYear;
        }
        return testYear <= -1 ? testYear : testYear - 1;
    }

    public static int getFixedDateFar1(int year, boolean afterH) {
        if (year <= 0) {
            throw new IllegalArgumentException("Year cannot be negative or zero. Year: " + year);
        }
        if (afterH && year >= 1349 && year < 1349 + FIXED_DATES.length - 1) {
            return FIXED_DATES[year - 1349];
        }
        int realYear = afterH ? year - 1 : -year;
        int days = 1029983 * (int)Math.floor((double)(realYear + 38) / 2820.0);
        int cycle = (realYear + 38) % 2820;
        if (cycle < 0) {
            cycle += 2820;
        }
        days = (int)((double)days + (Math.floor((double)(cycle - 38) * 365.24219) + 1.0));
        double extra = (double)cycle * 0.24219;
        int frac = MathExt.getIntegerPart((double)((extra - Math.floor(extra)) * 1000.0));
        int lastYear = year - 1;
        if (afterH && year == 1) {
            lastYear = 1;
        } else if (!afterH) {
            lastYear = year + 1;
        }
        if (PersianCalendar.isLeapYear(lastYear) && frac <= 202) {
            ++days;
        }
        return days;
    }

    public final int daysInMonth() {
        return PersianCalendar.daysInMonth(PersianCalendar.isLeapYear(this.fields[1]), this.fields[2]);
    }

    public static int daysInMonth(boolean leapYear, int month) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException();
        }
        if (month == 11) {
            if (leapYear) {
                return 30;
            }
            return 29;
        }
        return ACCUMULATED_DAYS_IN_MONTH[month + 1] - ACCUMULATED_DAYS_IN_MONTH[month];
    }

    public final int daysInYear() {
        return this.daysInYear(this.fields[1]);
    }

    private int daysInYear(int year) {
        return PersianCalendar.isLeapYear(year) ? 366 : 365;
    }

    public static boolean isLeapYear(double year) {
        year = (double)((year = (year - 474.0) % 128.0) >= 30.0 ? 0 : 29) + year;
        year = year - Math.floor(year / 33.0) - 1.0;
        return year % 4.0 == 0.0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @SuppressLint(value={"UniqueConstants"})
    public static @interface Fields {
    }
}

