/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers;

import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.fragment.app.DialogFragment;
import com.olekdia.androidcommon.extensions.ColorExt;
import com.olekdia.datetimepickers.HapticFeedbackController;
import com.olekdia.datetimepickers.IKeyScheme;
import com.olekdia.datetimepickers.R;

public class PickerDialog
extends DialogFragment
implements IKeyScheme {
    protected DialogInterface.OnCancelListener mOnCancelListener;
    protected DialogInterface.OnDismissListener mOnDismissListener;
    protected HapticFeedbackController mHapticFeedbackController;
    protected int mNumeralSystem = 0;
    protected boolean mThemeDark = false;
    protected boolean mThemeDarkChanged = false;
    protected int mAccentColor = -1;
    protected int mPrimaryColor = -1;
    protected boolean mVibrate = true;
    protected boolean mDismissOnPause = false;
    protected boolean mAutoDismiss = false;
    protected String mTitle;
    protected int mOkResId = R.string.mdtp_ok;
    protected String mOkString;
    protected int mCancelResId = R.string.mdtp_cancel;
    protected String mCancelString;

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("theme_dark", this.mThemeDark);
        outState.putBoolean("theme_dark_changed", this.mThemeDarkChanged);
        outState.putInt("accent", this.mAccentColor);
        outState.putInt("primary", this.mPrimaryColor);
        outState.putBoolean("vibrate", this.mVibrate);
        outState.putBoolean("dismiss", this.mDismissOnPause);
        outState.putBoolean("auto_dismiss", this.mAutoDismiss);
        outState.putString("title", this.mTitle);
        outState.putInt("ok_resid", this.mOkResId);
        outState.putString("ok_string", this.mOkString);
        outState.putInt("cancel_resid", this.mCancelResId);
        outState.putString("cancel_string", this.mCancelString);
        outState.putInt("numeral_system", this.mNumeralSystem);
    }

    protected void restoreInstanceState(Bundle savedInstanceState) {
        this.mThemeDark = savedInstanceState.getBoolean("theme_dark");
        this.mThemeDarkChanged = savedInstanceState.getBoolean("theme_dark_changed");
        this.mAccentColor = savedInstanceState.getInt("accent");
        this.mPrimaryColor = savedInstanceState.getInt("primary");
        this.mVibrate = savedInstanceState.getBoolean("vibrate");
        this.mDismissOnPause = savedInstanceState.getBoolean("dismiss");
        this.mAutoDismiss = savedInstanceState.getBoolean("auto_dismiss");
        this.mTitle = savedInstanceState.getString("title");
        this.mOkResId = savedInstanceState.getInt("ok_resid");
        this.mOkString = savedInstanceState.getString("ok_string");
        this.mCancelResId = savedInstanceState.getInt("cancel_resid");
        this.mCancelString = savedInstanceState.getString("cancel_string");
        this.mNumeralSystem = savedInstanceState.getInt("numeral_system");
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
        if (this.mDismissOnPause) {
            this.dismiss();
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (this.mOnCancelListener != null) {
            this.mOnCancelListener.onCancel(dialog);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public final void setNumeralSystem(int system) {
        this.mNumeralSystem = system;
    }

    public int getNumeralSystem() {
        return this.mNumeralSystem;
    }

    public final void setVibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    public void tryVibrate() {
        if (this.mVibrate) {
            this.mHapticFeedbackController.tryVibrate();
        }
    }

    public final void autoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
    }

    public final void dismissOnPause(boolean dismissOnPause) {
        this.mDismissOnPause = dismissOnPause;
    }

    public final void setThemeDark(boolean themeDark) {
        this.mThemeDark = themeDark;
        this.mThemeDarkChanged = true;
    }

    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    public final void setAccentColor(@ColorInt int color2) {
        this.mAccentColor = ColorExt.withAlpha((int)color2, (float)1.0f);
    }

    public int getAccentColor() {
        return this.mAccentColor;
    }

    public int getPrimaryColor() {
        return this.mPrimaryColor;
    }

    public final void setTitle(String title) {
        this.mTitle = title;
    }

    public final String getTitle() {
        return this.mTitle;
    }

    public void setOkText(String okString) {
        this.mOkString = okString;
    }

    public final void setOkText(@StringRes int resId) {
        this.mOkString = null;
        this.mOkResId = resId;
    }

    public final void setCancelText(String cancelString) {
        this.mCancelString = cancelString;
    }

    public final void setCancelText(@StringRes int resId) {
        this.mCancelString = null;
        this.mCancelResId = resId;
    }

    public final void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mOnCancelListener = onCancelListener;
    }

    public final void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }
}

