/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import com.olekdia.androidcommon.extensions.ResExt;
import com.olekdia.datetimepickers.R;

public class DTPickersHelper {
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int PULSE_ANIMATOR_DURATION = 544;

    public static ObjectAnimator getPulseAnimator(View labelToAnimate, float decreaseRatio, float increaseRatio) {
        Keyframe k0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe k1 = Keyframe.ofFloat((float)0.275f, (float)decreaseRatio);
        Keyframe k2 = Keyframe.ofFloat((float)0.69f, (float)increaseRatio);
        Keyframe k3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        ObjectAnimator pulseAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)labelToAnimate, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
        pulseAnimator.setDuration(544L);
        return pulseAnimator;
    }

    public static int getAccentColorFromThemeIfAvailable(Context context) {
        TypedValue typedValue = new TypedValue();
        if (Build.VERSION.SDK_INT >= 21) {
            context.getTheme().resolveAttribute(16843829, typedValue, true);
            return typedValue.data;
        }
        int colorAccentResId = context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        if (colorAccentResId != 0 && context.getTheme().resolveAttribute(colorAccentResId, typedValue, true)) {
            return typedValue.data;
        }
        return ResExt.getColorCompat((Context)context, (int)R.color.mdtp_accent_color);
    }

    public static int getPrimaryColorFromThemeIfAvailable(Context context) {
        TypedValue typedValue = new TypedValue();
        if (Build.VERSION.SDK_INT >= 21) {
            context.getTheme().resolveAttribute(16843827, typedValue, true);
            return typedValue.data;
        }
        int colorAccentResId = context.getResources().getIdentifier("colorPrimary", "attr", context.getPackageName());
        if (colorAccentResId != 0 && context.getTheme().resolveAttribute(colorAccentResId, typedValue, true)) {
            return typedValue.data;
        }
        return ResExt.getColorCompat((Context)context, (int)R.color.mdtp_primary_color);
    }

    public static boolean isDarkTheme(Context context, boolean current) {
        return ResExt.resolveBoolean((Context)context, (int)R.attr.mdtp_theme_dark, (boolean)current);
    }

    public static int indexDayToShiftedWeekIndexDay(int indexOfCalDay, int weekStart) {
        return ((indexOfCalDay + weekStart) % 7 + 5) % 7;
    }
}

