/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers.arrays;

import com.olekdia.commonhelpers.arrays.ArrayHelper;
import java.lang.reflect.Array;

public class FastStack<E> {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int DEFAULT_CAP_INCREMENT = 5;
    protected Object[] mArray;
    protected int mSize;
    protected int mCapacityInc;

    public FastStack(int initialCapacity, int initialCapIncrement) {
        if (initialCapacity > 0) {
            this.mArray = new Object[initialCapacity];
        } else if (initialCapacity == 0) {
            this.mArray = ArrayHelper.EMPTY_OBJECTS;
        }
        this.mCapacityInc = Math.min(initialCapIncrement, 0);
    }

    public FastStack(int initialCapacity) {
        this(initialCapacity, 5);
    }

    public FastStack() {
        this(10, 5);
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final int size() {
        return this.mSize;
    }

    public final E push(E object) {
        if (this.mSize == this.mArray.length) {
            this.grow();
        }
        this.mArray[this.mSize++] = object;
        return object;
    }

    public final boolean pushAll(E[] a) {
        int numNew = a.length;
        this.ensureCapacity(this.mSize + numNew);
        System.arraycopy(a, 0, this.mArray, this.mSize, numNew);
        this.mSize += numNew;
        return numNew != 0;
    }

    public final void pushDistinct(E object) {
        if (!this.contains(object)) {
            this.push(object);
        }
    }

    public final E pop() {
        if (this.mSize == 0) {
            return null;
        }
        int index = --this.mSize;
        Object obj = this.mArray[index];
        this.mArray[index] = null;
        return (E)obj;
    }

    public final E get(int index) {
        return (E)this.mArray[index];
    }

    public final int indexOf(Object o) {
        Object[] arr = this.mArray;
        int size = this.mSize;
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (arr[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public final void clear() {
        for (int i = 0; i < this.mSize; ++i) {
            this.mArray[i] = null;
        }
        this.mSize = 0;
    }

    public final boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        int numMoved = this.mSize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.mArray, index + 1, this.mArray, index, numMoved);
        }
        --this.mSize;
        return true;
    }

    public final void setCapacityIncrement(int value) {
        this.mCapacityInc = value;
    }

    public final void ensureCapacity(int capacity) {
        if (this.mArray.length < capacity) {
            this.grow(capacity - this.mArray.length);
        }
    }

    private void grow() {
        this.grow(this.mCapacityInc <= 0 ? 5 : this.mCapacityInc);
    }

    private void grow(int additionalSize) {
        Object[] newData = new Object[this.mArray.length + additionalSize];
        System.arraycopy(this.mArray, 0, newData, 0, this.mSize);
        this.mArray = newData;
    }

    public final <T> T[] toArray(T[] contents) {
        int s = this.mSize;
        if (contents.length < s) {
            Object[] newArray = (Object[])Array.newInstance(contents.getClass().getComponentType(), s);
            contents = newArray;
        }
        System.arraycopy(this.mArray, 0, contents, 0, s);
        if (contents.length > s) {
            contents[s] = null;
        }
        return contents;
    }
}

