/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.text.Html;
import android.text.Spanned;
import android.text.format.DateFormat;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import java.io.File;
import java.util.Locale;

public class CompatHelper {
    private static final String HUAWEI_MANUFACTURER = "Huawei";

    public static File getExternalCacheDir(Context context) {
        if (HUAWEI_MANUFACTURER.equalsIgnoreCase(Build.MANUFACTURER)) {
            File[] dirs = ContextCompat.getExternalCacheDirs((Context)context);
            if (dirs.length > 0) {
                return dirs[0];
            }
            return context.getExternalCacheDir();
        }
        return context.getExternalCacheDir();
    }

    public static File getExternalFileDir(Context context, String type) {
        if (HUAWEI_MANUFACTURER.equalsIgnoreCase(Build.MANUFACTURER)) {
            File[] dirs = ContextCompat.getExternalFilesDirs((Context)context, (String)type);
            if (dirs.length > 0) {
                return dirs[0];
            }
            return context.getExternalFilesDir(type);
        }
        return context.getExternalFilesDir(type);
    }

    public static String getBestDateTimePattern(Locale locale, String skeleton) {
        return Build.VERSION.SDK_INT >= 18 ? DateFormat.getBestDateTimePattern((Locale)locale, (String)skeleton) : skeleton;
    }

    public static void setBackgroundCompat(View v, Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(drawable);
        } else {
            v.setBackgroundDrawable(drawable);
        }
    }

    public static void setTextAppearanceCompat(@NonNull TextView textView, @StyleRes int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setTextAppearance(resId);
        } else {
            textView.setTextAppearance(textView.getContext(), resId);
        }
    }

    public static Spanned fromHtmlCompat(String text) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)text, (int)0);
        }
        return Html.fromHtml((String)text);
    }

    public static void removeOnGlobalLayoutListenerCompat(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT < 16) {
            v.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        } else {
            v.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        }
    }

    public static void changeEdgeEffect(Resources res, int color) {
        if (Build.VERSION.SDK_INT < 21) {
            try {
                int glowDrawableId = res.getIdentifier("overscroll_glow", "drawable", "android");
                Drawable androidGlow = res.getDrawable(glowDrawableId);
                if (androidGlow != null) {
                    androidGlow.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
                }
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }
}

