/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.AttrRes;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.Formatter;

public class CommonHelper {
    public static final int RESOURCE_NOT_FOUND = 0;
    public static final int INVALID = -1;
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;

    public static void clearFormatter(Formatter f) {
        ((StringBuilder)f.out()).setLength(0);
    }

    public static void cleanUpMemory() {
        System.runFinalization();
        Runtime.getRuntime().gc();
        System.gc();
    }

    public static void sleepOnThread(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static float dpToPx(float dp, Resources res) {
        return dp * ((float)res.getDisplayMetrics().densityDpi / 160.0f);
    }

    public static int dpToPx(int dp, Resources res) {
        return (int)CommonHelper.dpToPx((float)dp, res);
    }

    public static int spToPx(float sp, Resources res) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)res.getDisplayMetrics());
    }

    public static float pxToDp(float px, Resources res) {
        return px / ((float)res.getDisplayMetrics().densityDpi / 160.0f);
    }

    public static int getScreenSize(Resources res) {
        return res.getConfiguration().screenLayout & 0xF;
    }

    public static boolean isLargeScreen(Resources res) {
        int screenSize = CommonHelper.getScreenSize(res);
        return screenSize == 3 || screenSize == 4;
    }

    public static boolean isSmallScreen(Resources res) {
        return CommonHelper.getScreenSize(res) == 1;
    }

    public static boolean isPortOrientation(Resources res) {
        return res.getConfiguration().orientation == 1;
    }

    public static boolean isLandOrientation(Resources res) {
        return res.getConfiguration().orientation == 2;
    }

    public static int getOrientation(Resources res) {
        return res.getConfiguration().orientation;
    }

    public static float getScreenHeight(Resources res) {
        DisplayMetrics displayMetrics = res.getDisplayMetrics();
        return (float)displayMetrics.heightPixels / displayMetrics.density;
    }

    public static float getScreenWidth(Resources res) {
        DisplayMetrics displayMetrics = res.getDisplayMetrics();
        return (float)displayMetrics.widthPixels / displayMetrics.density;
    }

    public static int boolToInt(boolean value) {
        return value ? 1 : 0;
    }

    public static boolean intToBool(int value) {
        return value > 0;
    }

    public static int idToIndex(int id) {
        return id - 1;
    }

    public static int indexToId(int index) {
        return index + 1;
    }

    public static int indexToCount(int index) {
        return index + 1;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isAvailable() && netInfo.isConnected();
    }

    public static boolean resolveBoolean(Context context, @AttrRes int attr) {
        return CommonHelper.resolveBoolean(context, attr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveBoolean(Context context, @AttrRes int attr, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public static Drawable resolveDrawable(Context context, @AttrRes int attr) {
        return CommonHelper.resolveDrawable(context, attr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Drawable resolveDrawable(Context context, @AttrRes int attr, Drawable fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            Drawable d = a.getDrawable(0);
            if (d == null && fallback != null) {
                d = fallback;
            }
            Drawable drawable = d;
            return drawable;
        }
        finally {
            a.recycle();
        }
    }

    public static int resolveDimension(Context context, @AttrRes int attr) {
        return CommonHelper.resolveDimension(context, attr, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolveDimension(Context context, @AttrRes int attr, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            int n = a.getDimensionPixelSize(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static int resolveColor(Context context, @AttrRes int attr) {
        return CommonHelper.resolveColor(context, attr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resolveColor(Context context, @AttrRes int attr, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static String resolveString(Context context, @AttrRes int attr) {
        TypedValue v = new TypedValue();
        context.getTheme().resolveAttribute(attr, v, true);
        return (String)v.string;
    }

    public static Activity getActivity(Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }
}

