/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileHelper {
    public static void transferFile(FileChannel src, FileChannel dst) throws IOException {
        dst.transferFrom(src, 0L, src.size());
        src.close();
        dst.close();
    }

    public static boolean isFilePath(String value) {
        return value != null && value.startsWith("/");
    }

    public static boolean isDocumentFileUri(String value) {
        return value != null && value.startsWith("content://");
    }

    public static String getFilePathFromFullPath(String fullPath) {
        int lastIndex = fullPath.lastIndexOf(47);
        return lastIndex > 0 ? fullPath.substring(0, lastIndex + 1) : fullPath;
    }

    public static String getFileNameFromFullPath(String fullPath) {
        int lastIndex = fullPath.lastIndexOf(47);
        return lastIndex > 0 ? fullPath.substring(lastIndex + 1) : fullPath;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        int lastIndex = fileName.lastIndexOf(46);
        return lastIndex > 0 ? fileName.substring(0, lastIndex + 1) : fileName;
    }

    public static String getExtensionFromFileName(String fileName) {
        int lastIndex = fileName.lastIndexOf(46);
        return lastIndex >= 0 ? fileName.substring(lastIndex) : "";
    }

    public static String getFileNameFromUri(@NonNull Uri uri, ContentResolver cr) {
        String result = "";
        if ("file".equals(uri.getScheme())) {
            result = FileHelper.getFilePathFromFullPath(uri.getPath());
        } else if ("content".equals(uri.getScheme())) {
            try (Cursor cursor = cr.query(uri, new String[]{"_display_name"}, null, null, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    result = cursor.getString(cursor.getColumnIndex("_display_name"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean isMediaDoc(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadDoc(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isExternalStoreDoc(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isGoogleDisk(Uri uri) {
        return "com.google.android.apps.docs.storage".equals(uri.getAuthority());
    }
}

