/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

import android.support.v4.util.SimpleArrayMap;
import android.util.Log;

public final class DebugHelper {
    public static final String TAG = "DebugHelper";
    public static SimpleArrayMap<String, Long> sMeasureMap = new SimpleArrayMap();

    public static void startMeasureNano() {
        DebugHelper.startMeasureNano(TAG);
    }

    public static void startMeasureNano(String tag) {
        sMeasureMap.put((Object)tag, (Object)System.nanoTime());
    }

    public static void stopMeasureNano() {
        DebugHelper.stopMeasureNano(TAG);
    }

    public static long stopMeasureNano(String tag) {
        if (sMeasureMap.containsKey((Object)tag)) {
            long result = System.nanoTime() - (Long)sMeasureMap.get((Object)tag);
            Log.d((String)tag, (String)(result + " ns"));
            return result;
        }
        return 0L;
    }

    public static void startMeasure() {
        DebugHelper.startMeasure(TAG);
    }

    public static void startMeasure(String tag) {
        sMeasureMap.put((Object)tag, (Object)System.currentTimeMillis());
    }

    public static void stopMeasure() {
        DebugHelper.stopMeasure(TAG);
    }

    public static long stopMeasure(String tag) {
        if (sMeasureMap.containsKey((Object)tag)) {
            long result = System.currentTimeMillis() - (Long)sMeasureMap.get((Object)tag);
            Log.d((String)tag, (String)(result + " ms"));
            return result;
        }
        return 0L;
    }

    public static void log(String tag, int ... args) {
        String result = "";
        for (int arg : args) {
            result = result + arg + ", ";
        }
        Log.d((String)tag, (String)result);
    }

    public static void log(String tag, float ... args) {
        String result = "";
        for (float arg : args) {
            result = result + arg + ", ";
        }
        Log.d((String)tag, (String)result);
    }

    public static void log(String tag, double ... args) {
        String result = "";
        for (double arg : args) {
            result = result + arg + ", ";
        }
        Log.d((String)tag, (String)result);
    }

    public static void log(String tag, long ... args) {
        String result = "";
        for (long arg : args) {
            result = result + arg + ", ";
        }
        Log.d((String)tag, (String)result);
    }

    public static void log(String tag, boolean ... args) {
        String result = "";
        for (boolean arg : args) {
            result = result + arg + ", ";
        }
        Log.d((String)tag, (String)result);
    }

    public static void log(String tag, String ... args) {
        String result = "";
        for (String arg : args) {
            result = result + arg + ", ";
        }
        Log.d((String)tag, (String)result);
    }

    public static void log(String value) {
        Log.d((String)TAG, (String)value);
    }
}

