/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers.arrays;

import com.olekdia.commonhelpers.arrays.ArrayHelper;

public class FastLongStack {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int DEFAULT_CAP_INCREMENT = 5;
    protected long[] mArray;
    protected int mSize;
    protected int mCapacityInc;

    public FastLongStack(int initialCapacity, int initialCapIncrement) {
        if (initialCapacity > 0) {
            this.mArray = new long[initialCapacity];
        } else if (initialCapacity == 0) {
            this.mArray = ArrayHelper.EMPTY_LONGS;
        }
        this.mCapacityInc = Math.min(initialCapIncrement, 0);
    }

    public FastLongStack(int initialCapacity) {
        this(initialCapacity, 5);
    }

    public FastLongStack() {
        this(10, 5);
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final int size() {
        return this.mSize;
    }

    public final long push(long value) {
        if (this.mSize == this.mArray.length) {
            this.grow();
        }
        this.mArray[this.mSize++] = value;
        return value;
    }

    public final long pop() {
        if (this.mSize == 0) {
            return -1L;
        }
        int index = --this.mSize;
        long value = this.mArray[index];
        this.mArray[index] = -1L;
        return value;
    }

    public final int indexOf(long value) {
        long[] arr = this.mArray;
        int size = this.mSize;
        for (int i = 0; i < size; ++i) {
            if (value != arr[i]) continue;
            return i;
        }
        return -1;
    }

    public final void clear() {
        if (this.mSize != 0) {
            this.mSize = 0;
        }
    }

    public final boolean remove(long value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return false;
        }
        int numMoved = this.mSize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.mArray, index + 1, this.mArray, index, numMoved);
        }
        --this.mSize;
        return true;
    }

    public final void setCapacityIncrement(int value) {
        this.mCapacityInc = value;
    }

    private void grow() {
        this.grow(this.mCapacityInc <= 0 ? 5 : this.mCapacityInc);
    }

    private void grow(int additionalSize) {
        long[] newArray = new long[this.mArray.length + additionalSize];
        System.arraycopy(this.mArray, 0, newArray, 0, this.mSize);
        this.mArray = newArray;
    }

    public final long[] toArray(long[] contents) {
        int s = this.mSize;
        if (contents.length < s) {
            contents = new long[s];
        }
        System.arraycopy(this.mArray, 0, contents, 0, s);
        return contents;
    }
}

