/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers.arrays;

import android.support.annotation.Nullable;
import com.olekdia.commonhelpers.MathHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ArrayHelper {
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final boolean[] EMPTY_BOOLS = new boolean[0];
    public static final Object[] EMPTY_OBJECTS = new Object[0];

    public static int binarySearch(long[] array, int size, long value) {
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            long midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(int[] array, int size, int value) {
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int idealIntArraySize(int need) {
        return ArrayHelper.idealByteArraySize(need * 4) / 4;
    }

    public static int idealByteArraySize(int need) {
        for (int i = 4; i < 32; ++i) {
            if (need > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return need;
    }

    public static ArrayList<Integer> asArrayList(int[] array) {
        int size = array.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            arrayList.add(array[i]);
        }
        return arrayList;
    }

    public static ArrayList<Long> asArrayList(long[] array) {
        int size = array.length;
        ArrayList<Long> arrayList = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            arrayList.add(array[i]);
        }
        return arrayList;
    }

    public static ArrayList<Boolean> asArrayList(boolean[] array) {
        int size = array.length;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(size);
        for (int i = 0; i < size; ++i) {
            arrayList.add(array[i]);
        }
        return arrayList;
    }

    public static long[] asLongArray(List<Long> list) {
        int size = list.size();
        long[] array = new long[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static long[] asLongArray(int[] intArray) {
        int size = intArray.length;
        long[] longArray = new long[size];
        for (int i = 0; i < size; ++i) {
            longArray[i] = intArray[i];
        }
        return longArray;
    }

    public static int[] asIntArray(List<Integer> list) {
        int size = list.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static boolean[] asBoolArray(List<Boolean> list) {
        int size = list.size();
        boolean[] array = new boolean[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static int indexOfArray(int[] array, int key) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (key != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfArray(long[] array, long key) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (key != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfArray(String[] array, String key) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!key.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfArray(Object[] array, Object key) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (key != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int[] addToArray(int[] a, int element) {
        int[] result = Arrays.copyOf(a, a.length + 1);
        result[result.length - 1] = element;
        return result;
    }

    public static long[] addToArray(long[] a, long element) {
        long[] result = Arrays.copyOf(a, a.length + 1);
        result[result.length - 1] = element;
        return result;
    }

    public static long[] removeFromArray(long[] a, long element) {
        int index = ArrayHelper.indexOfArray(a, element);
        long[] result = new long[a.length - 1];
        System.arraycopy(a, 0, result, 0, index);
        if (index < a.length - 1) {
            System.arraycopy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static long[] removeFromArray(long[] a, int index) {
        long[] result = new long[a.length - 1];
        System.arraycopy(a, 0, result, 0, index);
        if (index < a.length - 1) {
            System.arraycopy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    @Nullable
    public static Set<String> copySet(Set<String> inputSet) {
        return inputSet == null ? null : new HashSet<String>(inputSet);
    }

    @Nullable
    public static void fillArray(float[] in, float[] out) {
        System.arraycopy(in, 0, out, 0, in.length);
    }

    public static void shuffleList(List list) {
        int count = list.size() - 1;
        for (int i = 0; i <= count; ++i) {
            int j = MathHelper.getRandom(0, count);
            Collections.swap(list, i, j);
        }
    }

    public static void shuffleList(List list, Random rand) {
        int count = list.size() - 1;
        int size = list.size();
        for (int i = 0; i <= count; ++i) {
            int j = rand.nextInt(size);
            Collections.swap(list, i, j);
        }
    }
}

