/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

public class BitHelper {
    public static int bitToIndex(int bitSet) {
        return Integer.numberOfTrailingZeros(bitSet);
    }

    public static boolean isBitEnabled(int bitSet, int bit) {
        return (bitSet & bit) > 0;
    }

    public static boolean isBitIndexEnabled(int bitSet, int bitIndex) {
        return (bitSet & 1 << bitIndex) > 0;
    }

    public static int addBit(int bitSet, int bit) {
        return bitSet | bit;
    }

    public static long addBit(long bitSet, long bit) {
        return bitSet | bit;
    }

    public static int subtractBit(int bitSet, int bit) {
        return bitSet & ~bit;
    }

    public static long subtractBit(long bitSet, long bit) {
        return bitSet & (bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int addBitIndex(int bitSet, int bitIndex) {
        return bitSet |= 1 << bitIndex;
    }

    public static long addBitIndex(long bitSet, int bitIndex) {
        return bitSet |= (long)(1 << bitIndex);
    }

    public static int subtractBitIndex(int bitSet, int bitIndex) {
        return bitSet &= ~(1 << bitIndex);
    }

    public static long subtractBitIndex(long bitSet, int bitIndex) {
        return bitSet &= (long)(~(1 << bitIndex));
    }

    public static int addBitIndexes(int bitSet, int ... args) {
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            bitSet = BitHelper.addBitIndex(bitSet, args[i]);
        }
        return bitSet;
    }

    public static int subtractBitIndexes(int bitSet, int ... args) {
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            bitSet = BitHelper.subtractBitIndex(bitSet, args[i]);
        }
        return bitSet;
    }
}

