/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers.arrays;

import com.olekdia.commonhelpers.arrays.ArrayHelper;
import java.util.Arrays;

public class FastIntStack {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int DEFAULT_CAP_INCREMENT = 5;
    protected int[] mArray;
    protected int mSize;
    protected int mCapacityInc;

    public FastIntStack(int initialCapacity, int initialCapIncrement) {
        if (initialCapacity > 0) {
            this.mArray = new int[initialCapacity];
        } else if (initialCapacity == 0) {
            this.mArray = ArrayHelper.EMPTY_INTS;
        }
        this.mCapacityInc = Math.min(initialCapIncrement, 0);
    }

    public FastIntStack(int initialCapacity) {
        this(initialCapacity, 5);
    }

    public FastIntStack() {
        this(10, 5);
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final int size() {
        return this.mSize;
    }

    public final int push(int value) {
        if (this.mSize == this.mArray.length) {
            this.grow();
        }
        this.mArray[this.mSize++] = value;
        return value;
    }

    public final int pop() {
        if (this.mSize == 0) {
            return -1;
        }
        int index = --this.mSize;
        int value = this.mArray[index];
        this.mArray[index] = -1;
        return value;
    }

    public final int indexOf(int value) {
        int[] a = this.mArray;
        int s = this.mSize;
        for (int i = 0; i < s; ++i) {
            if (value != a[i]) continue;
            return i;
        }
        return -1;
    }

    public final void clear() {
        if (this.mSize != 0) {
            Arrays.fill(this.mArray, 0, this.mSize, -1);
            this.mSize = 0;
        }
    }

    public final void setCapacityIncrement(int value) {
        this.mCapacityInc = value;
    }

    private void grow() {
        this.grow(this.mCapacityInc <= 0 ? 5 : this.mCapacityInc);
    }

    private void grow(int additionalSize) {
        int[] newArray = new int[this.mArray.length + additionalSize];
        System.arraycopy(this.mArray, 0, newArray, 0, this.mSize);
        this.mArray = newArray;
    }
}

