/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

import android.graphics.PointF;
import java.util.Random;

public class MathHelper {
    public static final int DEG_2PI = 360;
    public static final float PI = (float)Math.PI;
    public static final float GOLDEN_RATIO = 1.61803f;

    public static int fastModulo(int dividend, int divisor) {
        return dividend & divisor - 1;
    }

    public static boolean isRounded(double value) {
        return value == (double)((int)value);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        return (double)Math.round(value *= (double)factor) / (double)factor;
    }

    public static float round(float value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        int factor = (int)Math.pow(10.0, places);
        return (float)Math.round(value *= (float)factor) / (float)factor;
    }

    public static float roundTo(float value, float to) {
        return value - Math.abs(value % to);
    }

    public static int roundTo(float value, int to) {
        return Math.round(value - value % (float)to);
    }

    public static long roundTo(double value, int to) {
        return Math.round(value - value % (double)to);
    }

    public static int roundTo(int value, int to) {
        return Math.round(value - value % to);
    }

    public static int roundToCeil(float value, int to) {
        if (value % (float)to == 0.0f) {
            return (int)value;
        }
        return Math.round(value - value % (float)to) + to;
    }

    public static int getIntegerPart(double d) {
        return d >= 0.0 ? (int)Math.floor(d) : (int)Math.floor(d) + 1;
    }

    public static int divideWithRoundUp(int what, int to) {
        return what / to + (what % to == 0 ? 0 : 1);
    }

    public static int min(int ... args) {
        int minResult = Integer.MAX_VALUE;
        for (int arg : args) {
            if (arg >= minResult) continue;
            minResult = arg;
        }
        return minResult;
    }

    public static int signum(int i) {
        return i > 0 ? 1 : (i < 0 ? -1 : 0);
    }

    public static int signum(long i) {
        return i > 0L ? 1 : (i < 0L ? -1 : 0);
    }

    public static int getRandom(int min, int max) {
        return (int)Math.floor(Math.random() * (double)(max - min + 1)) + min;
    }

    public static long getRandom(long min, long max) {
        return (long)Math.floor(Math.random() * (double)(max - min + 1L)) + min;
    }

    public static float getRandom(float min, float max) {
        return (float)Math.random() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static boolean getRandom() {
        return Math.random() > 0.5;
    }

    public static float getRandom(float min, float max, Random random) {
        return random.nextFloat() * (max - min) + min;
    }

    public static int getRandom(int min, int max, Random random) {
        return random.nextInt(max - min + 1) + min;
    }

    public static double toRadians(double value) {
        return value * Math.PI / 180.0;
    }

    public static float toRadians(float value) {
        return value * (float)Math.PI / 180.0f;
    }

    public static PointF toScreenCoordinates(PointF center, PointF point) {
        PointF resultPoint = new PointF();
        resultPoint.x = point.x + center.x;
        resultPoint.y = center.y - point.y;
        return resultPoint;
    }

    public static void toScreenCoordinates(PointF point, float cx, float cy, float px, float py) {
        point.set(px + cx, cy - py);
    }

    public static PointF toRealCoords(float x, float y, float cx, float cy) {
        PointF rp = new PointF();
        rp.x = x - cx;
        rp.y = y - cy;
        return rp;
    }

    public static boolean isInCircle(float x, float y, float cx, float cy, float r) {
        return (x - cx) * (x - cx) + (y - cy) * (y - cy) <= r * r;
    }

    public static boolean isOutsideCircle(PointF p, float radius, float strokeWidth) {
        return !MathHelper.isWithinRadius(p, radius - strokeWidth / 2.0f);
    }

    public static boolean isWithinRing(PointF p, float radius, float strokeWidth) {
        return MathHelper.isWithinRadius(p, radius + strokeWidth / 2.0f) && !MathHelper.isWithinRadius(p, radius - strokeWidth / 2.0f);
    }

    public static boolean isWithinRadius(PointF p, float radius) {
        return p.x * p.x + p.y * p.y <= radius * radius;
    }

    public static boolean areClockwise(PointF p, float cx, float cy, float radius, float angle) {
        double sy;
        float radAngle = MathHelper.toRadians(angle);
        double sx = (double)(cx + radius) * Math.cos(radAngle);
        return -sx * (double)p.y + (sy = (double)(cy + radius) * Math.sin(radAngle)) * (double)p.x > 0.0;
    }

    public static boolean isInsideAngle(PointF p, float cx, float cy, float radius, float angle1, float angle2) {
        if (angle2 - angle1 <= 180.0f) {
            return !MathHelper.areClockwise(p, cx, cy, radius, angle1) && MathHelper.areClockwise(p, cx, cy, radius, angle2);
        }
        return MathHelper.isInsideAngle(p, cx, cy, radius, angle1, angle1 + 180.0f) || MathHelper.isInsideAngle(p, cx, cy, radius, angle1 + 180.0f, angle2);
    }

    public static double segmentLength(float x1, float y1, float x2, float y2) {
        return Math.sqrt((double)(x1 - x2) * (double)(x1 - x2) + (double)((y1 - y2) * (y1 - y2)));
    }

    public static int gcd(int a, int b) {
        while (a != 0 && b != 0) {
            int tmp = a %= b;
            a = b;
            b = tmp;
        }
        return a + b;
    }

    public static int lcm(int a, int b) {
        return a / MathHelper.gcd(a, b) * b;
    }

    public static int lcm(int a, int b, int c) {
        return MathHelper.lcm(a, MathHelper.lcm(b, c));
    }

    public static double geomProgressionItemN(long item1, double q, int n) {
        return (double)item1 * Math.pow(q, n - 1);
    }

    public static int log(int a, int x) {
        return (int)(Math.log(x) / Math.log(a));
    }

    public static int numDigits(int number) {
        return number == 0 ? 1 : (number < 0 ? (int)Math.log10(-number) + 2 : (int)Math.log10(number) + 1);
    }
}

