/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers.arrays;

import com.olekdia.commonhelpers.arrays.ArrayHelper;

public class FastLongKeySparseBooleanArray
implements Cloneable {
    private long[] mKeys;
    private boolean[] mValues;
    private int mSize;

    public FastLongKeySparseBooleanArray() {
        this(10);
    }

    public FastLongKeySparseBooleanArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = ArrayHelper.EMPTY_LONGS;
            this.mValues = ArrayHelper.EMPTY_BOOLS;
        } else {
            initialCapacity = ArrayHelper.idealIntArraySize(initialCapacity);
            this.mKeys = new long[initialCapacity];
            this.mValues = new boolean[this.mKeys.length];
        }
        this.mSize = 0;
    }

    public final FastLongKeySparseBooleanArray clone() {
        FastLongKeySparseBooleanArray clone = null;
        try {
            clone = (FastLongKeySparseBooleanArray)super.clone();
            clone.mKeys = (long[])this.mKeys.clone();
            clone.mValues = (boolean[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public final boolean get(long key) {
        return this.get(key, false);
    }

    public final boolean get(long key, boolean valueIfKeyNotFound) {
        int i = ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public final boolean delete(int key) {
        int i = ArrayHelper.binarySearch(this.mKeys, this.mSize, (long)key);
        if (i >= 0) {
            System.arraycopy(this.mKeys, i + 1, this.mKeys, i, this.mSize - (i + 1));
            System.arraycopy(this.mValues, i + 1, this.mValues, i, this.mSize - (i + 1));
            --this.mSize;
            return true;
        }
        return false;
    }

    public final void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public final void put(long key, boolean value) {
        int i = ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            i ^= 0xFFFFFFFF;
            if (this.mSize >= this.mKeys.length) {
                this.expandToCapacity(ArrayHelper.idealIntArraySize(this.mSize + 1));
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = value;
            ++this.mSize;
        }
    }

    public final int size() {
        return this.mSize;
    }

    public final long keyAt(int index) {
        return this.mKeys[index];
    }

    public final boolean valueAt(int index) {
        return this.mValues[index];
    }

    public final void setValueAt(int index, boolean value) {
        this.mValues[index] = value;
    }

    public final void setKeyAt(int index, long key) {
        this.mKeys[index] = key;
    }

    public final int indexOfKey(long key) {
        return ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
    }

    public final int indexOfValue(boolean value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public final void clear() {
        this.mSize = 0;
    }

    public final void append(long key, boolean value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        int pos = this.mSize;
        if (pos >= this.mKeys.length) {
            this.expandToCapacity(ArrayHelper.idealIntArraySize(pos + 1));
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public final void ensureCapacity(int capacity) {
        if (this.mKeys.length < capacity) {
            this.expandToCapacity(capacity);
        }
    }

    private void expandToCapacity(int capacity) {
        long[] nkeys = new long[capacity];
        boolean[] nvalues = new boolean[capacity];
        System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
        System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
        this.mKeys = nkeys;
        this.mValues = nvalues;
    }
}

