/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.support.v4.util.SimpleArrayMap;
import android.text.Html;
import android.text.format.DateFormat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Formatter;
import java.util.Locale;

public class CommonHelper {
    public static final int RESOURCE_NOT_FOUND = 0;
    public static final int INVALID = -1;
    public static final char ZERO_DIGIT = '0';
    public static final char NINE_DIGIT = '9';
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final char PDF = '\u202c';
    public static final char PDI = '\u2069';
    public static final char LRM = '\u200e';
    public static final char RLM = '\u200f';
    public static final char LRI = '\u2066';
    public static final char RLI = '\u2067';
    public static final char FSI = '\u2068';
    public static final char LRO = '\u202d';
    public static final char RLO = '\u202e';
    public static final String AR_LANG = "ar";
    public static final String BG_LANG = "bg";
    public static final String CS_LANG = "cs";
    public static final String FA_LANG = "fa";
    public static final String GU_LANG = "gu";
    public static final String MR_LANG = "mr";
    public static final String TH_LANG = "th";
    public static final String IW_LANG = "iw";
    public static final String PL_LANG = "pl";
    public static final String RU_LANG = "ru";
    public static final String UK_LANG = "uk";
    public static final String ZH_LANG = "zh";
    public static final String[] NUMBERS_0_31_WESTERN_ARABIC = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    public static final String[] NUMBERS_0_31_EASTERN_ARABIC = new String[]{"\u0660", "\u0661", "\u0662", "\u0663", "\u0664", "\u0665", "\u0666", "\u0667", "\u0668", "\u0669", "\u0661\u0660", "\u0661\u0661", "\u0661\u0662", "\u0661\u0663", "\u0661\u0664", "\u0661\u0665", "\u0661\u0666", "\u0661\u0667", "\u0661\u0668", "\u0661\u0669", "\u0662\u0660", "\u0662\u0661", "\u0662\u0662", "\u0662\u0663", "\u0662\u0664", "\u0662\u0665", "\u0662\u0666", "\u0662\u0667", "\u0662\u0668", "\u0662\u0669", "\u0663\u0660", "\u0663\u0661"};
    public static final String[] NUMBERS_0_31_PERSO_ARABIC = new String[]{"\u06f0", "\u06f1", "\u06f2", "\u06f3", "\u06f4", "\u06f5", "\u06f6", "\u06f7", "\u06f8", "\u06f9", "\u06f1\u06f0", "\u06f1\u06f1", "\u06f1\u06f2", "\u06f1\u06f3", "\u06f1\u06f4", "\u06f1\u06f5", "\u06f1\u06f6", "\u06f1\u06f7", "\u06f1\u06f8", "\u06f1\u06f9", "\u06f2\u06f0", "\u06f2\u06f1", "\u06f2\u06f2", "\u06f2\u06f3", "\u06f2\u06f4", "\u06f2\u06f5", "\u06f2\u06f6", "\u06f2\u06f7", "\u06f2\u06f8", "\u06f2\u06f9", "\u06f3\u06f0", "\u06f3\u06f1"};
    public static final String[] NUMBERS_0_31_GUJARATI = new String[]{"\u0ae6", "\u0ae7", "\u0ae8", "\u0ae9", "\u0aea", "\u0aeb", "\u0aec", "\u0aed", "\u0aee", "\u0aef", "\u0ae7\u0ae6", "\u0ae7\u0ae7", "\u0ae7\u0ae8", "\u0ae7\u0ae9", "\u0ae7\u0aea", "\u0ae7\u0aeb", "\u0ae7\u0aec", "\u0ae7\u0aed", "\u0ae7\u0aee", "\u0ae7\u0aef", "\u0ae8\u0ae6", "\u0ae8\u0ae7", "\u0ae8\u0ae8", "\u0ae8\u0ae9", "\u0ae8\u0aea", "\u0ae8\u0aeb", "\u0ae8\u0aec", "\u0ae8\u0aed", "\u0ae8\u0aee", "\u0ae8\u0aef", "\u0ae9\u0ae6", "\u0ae9\u0ae7"};
    public static final String[] NUMBERS_0_31_DEVANAGARI = new String[]{"\u0966", "\u0967", "\u0968", "\u0969", "\u096a", "\u096b", "\u096c", "\u096d", "\u096e", "\u096f", "\u0967\u0966", "\u0967\u0967", "\u0967\u0968", "\u0967\u0969", "\u0967\u096a", "\u0967\u096b", "\u0967\u096c", "\u0967\u096d", "\u0967\u096e", "\u0967\u096f", "\u0968\u0966", "\u0968\u0967", "\u0968\u0968", "\u0968\u0969", "\u0968\u096a", "\u0968\u096b", "\u0968\u096c", "\u0968\u096d", "\u0968\u096e", "\u0968\u096f", "\u0969\u0966", "\u0969\u0967"};
    public static final String[] NUMBERS_0_31_THAI = new String[]{"\u0e50", "\u0e51", "\u0e52", "\u0e53", "\u0e54", "\u0e55", "\u0e56", "\u0e57", "\u0e58", "\u0e59", "\u0e51\u0e50", "\u0e51\u0e51", "\u0e51\u0e52", "\u0e51\u0e53", "\u0e51\u0e54", "\u0e51\u0e55", "\u0e51\u0e56", "\u0e51\u0e57", "\u0e51\u0e58", "\u0e51\u0e59", "\u0e52\u0e50", "\u0e52\u0e51", "\u0e52\u0e52", "\u0e52\u0e53", "\u0e52\u0e54", "\u0e52\u0e55", "\u0e52\u0e56", "\u0e52\u0e57", "\u0e52\u0e58", "\u0e52\u0e59", "\u0e53\u0e50", "\u0e53\u0e51"};
    public static final char[] DIGITS_WESTERN_ARABIC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] DIGITS_EASTERN_ARABIC = new char[]{'\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669'};
    public static final char[] DIGITS_PERSO_ARABIC = new char[]{'\u06f0', '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', '\u06f9'};
    public static final char[] DIGITS_GUJARATI = new char[]{'\u0ae6', '\u0ae7', '\u0ae8', '\u0ae9', '\u0aea', '\u0aeb', '\u0aec', '\u0aed', '\u0aee', '\u0aef'};
    public static final char[] DIGITS_DEVANAGARI = new char[]{'\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f'};
    public static final char[] DIGITS_THAI = new char[]{'\u0e50', '\u0e51', '\u0e52', '\u0e53', '\u0e54', '\u0e55', '\u0e56', '\u0e57', '\u0e58', '\u0e59'};
    public static final int WESTERN_ARABIC = 0;
    public static final int EASTERN_ARABIC = 1;
    public static final int PERSO_ARABIC = 2;
    public static final int GUJARATI = 3;
    public static final int DEVANAGARI = 4;
    public static final int THAI = 5;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final String ROBOTO_C_BOLD_FONT = "RobotoCondensed-Bold";
    public static final String ROBOTO_C_LIGHT_FONT = "RobotoCondensed-Light";
    public static final String ROBOTO_MEDIUM_FONT = "Roboto-Medium";
    private static final SimpleArrayMap<String, Typeface> sCache = new SimpleArrayMap();
    private static final StringBuilder sBuilder = new StringBuilder();
    private static final StringBuilder sFmtBuilder = new StringBuilder(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface getTypeface(Context ctx, String name) {
        SimpleArrayMap<String, Typeface> simpleArrayMap = sCache;
        synchronized (simpleArrayMap) {
            if (!sCache.containsKey((Object)name)) {
                sBuilder.setLength(0);
                Typeface t = Typeface.createFromAsset((AssetManager)ctx.getAssets(), (String)sBuilder.append("fonts/").append(name).append(".ttf").toString());
                sCache.put((Object)name, (Object)t);
                return t;
            }
            return (Typeface)sCache.get((Object)name);
        }
    }

    public static boolean isLayoutRtl(Resources res) {
        if (Build.VERSION.SDK_INT >= 17) {
            return res.getConfiguration().getLayoutDirection() == 1;
        }
        switch (Locale.getDefault().getLanguage()) {
            case "ar": 
            case "fa": 
            case "iw": {
                return true;
            }
        }
        return false;
    }

    public static void setBackgroundCompat(View v, Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(drawable);
        } else {
            v.setBackgroundDrawable(drawable);
        }
    }

    public static void setTextAppearanceCompat(@NonNull TextView textView, @StyleRes int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setTextAppearance(resId);
        } else {
            textView.setTextAppearance(textView.getContext(), resId);
        }
    }

    public static CharSequence fromHtmlCompat(String text) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)text, (int)0);
        }
        return Html.fromHtml((String)text);
    }

    public static float dpToPx(float dp, Resources res) {
        return dp * ((float)res.getDisplayMetrics().densityDpi / 160.0f);
    }

    public static int dpToPx(int dp, Resources res) {
        return (int)CommonHelper.dpToPx((float)dp, res);
    }

    public static int spToPx(float sp, Resources res) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)res.getDisplayMetrics());
    }

    public static float pxToDp(float px, Resources res) {
        return px / ((float)res.getDisplayMetrics().densityDpi / 160.0f);
    }

    public static int getScreenSize(Resources res) {
        return res.getConfiguration().screenLayout & 0xF;
    }

    public static boolean isLargeScreen(Resources res) {
        int screenSize = CommonHelper.getScreenSize(res);
        return screenSize == 3 || screenSize == 4;
    }

    public static boolean isSmallScreen(Resources res) {
        return CommonHelper.getScreenSize(res) == 1;
    }

    public static boolean isPortOrientation(Resources res) {
        return res.getConfiguration().orientation == 1;
    }

    public static boolean isLandOrientation(Resources res) {
        return res.getConfiguration().orientation == 2;
    }

    public static int getOrientation(Resources res) {
        return res.getConfiguration().orientation;
    }

    public static float getScreenHeight(Resources res) {
        DisplayMetrics displayMetrics = res.getDisplayMetrics();
        return (float)displayMetrics.heightPixels / displayMetrics.density;
    }

    public static float getScreenWidth(Resources res) {
        DisplayMetrics displayMetrics = res.getDisplayMetrics();
        return (float)displayMetrics.widthPixels / displayMetrics.density;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isAvailable() && netInfo.isConnected();
    }

    public static boolean resolveBoolean(Context context, @AttrRes int attr) {
        return CommonHelper.resolveBoolean(context, attr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveBoolean(Context context, @AttrRes int attr, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public static Drawable resolveDrawable(Context context, @AttrRes int attr) {
        return CommonHelper.resolveDrawable(context, attr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Drawable resolveDrawable(Context context, @AttrRes int attr, Drawable fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            Drawable d = a.getDrawable(0);
            if (d == null && fallback != null) {
                d = fallback;
            }
            Drawable drawable = d;
            return drawable;
        }
        finally {
            a.recycle();
        }
    }

    public static int resolveDimension(Context context, @AttrRes int attr) {
        return CommonHelper.resolveDimension(context, attr, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolveDimension(Context context, @AttrRes int attr, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            int n = a.getDimensionPixelSize(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static int resolveColor(Context context, @AttrRes int attr) {
        return CommonHelper.resolveColor(context, attr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resolveColor(Context context, @AttrRes int attr, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static String resolveString(Context context, @AttrRes int attr) {
        TypedValue v = new TypedValue();
        context.getTheme().resolveAttribute(attr, v, true);
        return (String)v.string;
    }

    private static char[] getDigits(int numSystem) {
        switch (numSystem) {
            default: {
                return DIGITS_WESTERN_ARABIC;
            }
            case 1: {
                return DIGITS_EASTERN_ARABIC;
            }
            case 2: {
                return DIGITS_PERSO_ARABIC;
            }
            case 3: {
                return DIGITS_GUJARATI;
            }
            case 4: {
                return DIGITS_DEVANAGARI;
            }
            case 5: 
        }
        return DIGITS_THAI;
    }

    private static String[] getNumbers31(int numSystem) {
        switch (numSystem) {
            default: {
                return NUMBERS_0_31_WESTERN_ARABIC;
            }
            case 1: {
                return NUMBERS_0_31_EASTERN_ARABIC;
            }
            case 2: {
                return NUMBERS_0_31_PERSO_ARABIC;
            }
            case 3: {
                return NUMBERS_0_31_GUJARATI;
            }
            case 4: {
                return NUMBERS_0_31_DEVANAGARI;
            }
            case 5: 
        }
        return NUMBERS_0_31_THAI;
    }

    public static String formatNumber31(int number, int numSystem) {
        return CommonHelper.getNumbers31(numSystem)[number];
    }

    public static void convertNumbers(StringBuilder b, int numSystem) {
        int count = b.length();
        if (count == 0 || numSystem == 0) {
            return;
        }
        char[] digits = CommonHelper.getDigits(numSystem);
        for (int i = 0; i < count; ++i) {
            char currChar = b.charAt(i);
            if (currChar < '0' || currChar > '9') continue;
            b.setCharAt(i, digits[currChar - 48]);
        }
    }

    public static CharSequence convertNumbers(CharSequence text, int numSystem) {
        if (numSystem == 0) {
            return text;
        }
        sFmtBuilder.setLength(0);
        sFmtBuilder.append(text);
        CommonHelper.convertNumbers(sFmtBuilder, numSystem);
        return sFmtBuilder.toString();
    }

    public static CharSequence[] convertNumbers(CharSequence[] arr, int numSystem) {
        if (numSystem == 0) {
            return arr;
        }
        for (int i = arr.length - 1; i >= 0; --i) {
            arr[i] = CommonHelper.convertNumbers(arr[i], numSystem);
        }
        return arr;
    }

    public static String formatInt(int value, int numSystem) {
        sFmtBuilder.setLength(0);
        sFmtBuilder.append(value);
        CommonHelper.convertNumbers(sFmtBuilder, numSystem);
        return sFmtBuilder.toString();
    }

    public static String formatLong(long value, int numSystem) {
        sFmtBuilder.setLength(0);
        sFmtBuilder.append(value);
        CommonHelper.convertNumbers(sFmtBuilder, numSystem);
        return sFmtBuilder.toString();
    }

    public static String formatIntTwoDig(int value) {
        return CommonHelper.formatIntTwoDig(value, 0);
    }

    public static String formatIntTwoDig(int value, int numSystem) {
        sFmtBuilder.setLength(0);
        if (value <= 0) {
            sFmtBuilder.append('0').append('0');
        } else if (value < 10) {
            sFmtBuilder.append('0').append(value);
        } else if (value >= 10) {
            sFmtBuilder.append(value);
        }
        CommonHelper.convertNumbers(sFmtBuilder, numSystem);
        return sFmtBuilder.toString();
    }

    public static void clearFormatter(Formatter f) {
        ((StringBuilder)f.out()).setLength(0);
    }

    public static String getBestDateTimePattern(Locale locale, String skeleton) {
        return Build.VERSION.SDK_INT >= 18 ? DateFormat.getBestDateTimePattern((Locale)locale, (String)skeleton) : skeleton;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NumeralSystem {
    }
}

