/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.commonhelpers;

import android.graphics.Color;
import android.support.annotation.ColorInt;

public class ColorHelper {
    public static final int ALPHA_MASK = 0xFFFFFF;
    public static final int MAX_CHANEL = 255;

    public static float getAlphaPercent(int argb) {
        return (float)Color.alpha((int)argb) / 255.0f;
    }

    public static int alphaValueAsInt(float alpha) {
        return Math.round(alpha * 255.0f);
    }

    @ColorInt
    public static int adjustAlpha(int color, float alpha) {
        return Math.round((float)(color >>> 24) * alpha) << 24 | 0xFFFFFF & color;
    }

    @ColorInt
    public static int replaceAlpha(int color, int alpha) {
        return alpha << 24 | 0xFFFFFF & color;
    }

    @ColorInt
    public static int replaceAlpha(int color, float alpha) {
        return ColorHelper.alphaValueAsInt(alpha) << 24 | 0xFFFFFF & color;
    }

    @ColorInt
    public static int opaqueColor(int color) {
        return 0xFF000000 | 0xFFFFFF & color;
    }

    public static int colorAtLightness(int color, float lightness) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = lightness;
        return Color.HSVToColor((float[])hsv);
    }

    public static float lightnessOfColor(int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        return hsv[2];
    }

    @ColorInt
    public static int saturate(int color, float factor) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[1] = hsv[1] * factor;
        return Color.HSVToColor((float[])hsv);
    }

    @ColorInt
    public static int darker(int color, float factor) {
        return Color.argb((int)(color >>> 24), (int)Math.min(Math.max((int)((float)(color >> 16 & 0xFF) * factor), 0), 255), (int)Math.min(Math.max((int)((float)(color >> 8 & 0xFF) * factor), 0), 255), (int)Math.min(Math.max((int)((float)(color & 0xFF) * factor), 0), 255));
    }

    @ColorInt
    public static int toPastel(int color) {
        return 0xFF000000 | ((color >> 16 & 0xFF) + 255) / 2 << 16 | ((color >> 8 & 0xFF) + 255) / 2 << 8 | ((color & 0xFF) + 255) / 2;
    }

    @ColorInt
    public static int mixColor(int color, int mixedChanel) {
        return Color.rgb((int)((Color.red((int)color) + mixedChanel) / 2), (int)((Color.green((int)color) + mixedChanel) / 2), (int)((Color.blue((int)color) + mixedChanel) / 2));
    }

    @ColorInt
    public static int randomColor() {
        return ColorHelper.randomColor(-1);
    }

    @ColorInt
    public static int randomColor(int mix) {
        return Color.rgb((int)((int)(Math.random() * 255.0 + (double)Color.red((int)mix)) / 2), (int)((int)(Math.random() * 255.0 + (double)Color.green((int)mix)) / 2), (int)((int)(Math.random() * 255.0 + (double)Color.blue((int)mix)) / 2));
    }

    public static boolean isColorDark(int color) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color)) / 255.0;
        return darkness >= 0.5;
    }
}

