/*
 * Decompiled with CFR 0.152.
 */
package org.docopt;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.docopt.Argument;
import org.docopt.BranchPattern;
import org.docopt.Command;
import org.docopt.DocoptExitException;
import org.docopt.DocoptLanguageError;
import org.docopt.Either;
import org.docopt.LeafPattern;
import org.docopt.OneOrMore;
import org.docopt.Option;
import org.docopt.Optional;
import org.docopt.OptionsShortcut;
import org.docopt.Pattern;
import org.docopt.Python;
import org.docopt.Required;
import org.docopt.Tokens;

public final class Docopt {
    private final String doc;
    private final String usage;
    private final List<Option> options;
    private final Required pattern;
    private boolean help = true;
    private String version = null;
    private boolean optionsFirst = false;
    private boolean exit = true;
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    private static List<Option> parseLong(Tokens tokens, List<Option> options) {
        Option o;
        String[] a = Python.partition(tokens.move(), "=");
        String $long = a[0];
        String eq = a[1];
        String value = a[2];
        assert ($long.startsWith("--"));
        if ("".equals(eq) && "".equals(value)) {
            value = null;
        }
        List<Option> similar = Python.list();
        for (Option o2 : options) {
            if (!$long.equals(o2.getLong())) continue;
            similar.add(o2);
        }
        if (tokens.getError() == DocoptExitException.class && similar.isEmpty()) {
            for (Option o2 : options) {
                if (o2.getLong() == null || !o2.getLong().startsWith($long)) continue;
                similar.add(o2);
            }
        }
        if (similar.size() > 1) {
            List u = Python.list();
            for (Option o3 : similar) {
                u.add(o3.getLong());
            }
            throw tokens.error("%s is not a unique prefix: %s?", $long, Python.join(", ", u));
        }
        if (similar.size() < 1) {
            int argCount = "=".equals(eq) ? 1 : 0;
            o = new Option(null, $long, argCount);
            options.add(o);
            if (tokens.getError() == DocoptExitException.class) {
                o = new Option(null, $long, argCount, argCount != 0 ? value : Boolean.valueOf(true));
            }
        } else {
            Object u = similar.get(0);
            o = new Option(((Option)u).getShort(), ((Option)u).getLong(), ((Option)u).getArgCount(), ((LeafPattern)u).getValue());
            if (o.getArgCount() == 0) {
                if (value != null) {
                    throw tokens.error("%s must not have an argument", o.getLong());
                }
            } else if (value == null) {
                u = tokens.current();
                if (u == null || "--".equals(u)) {
                    throw tokens.error("%s requires argument", o.getLong());
                }
                value = tokens.move();
            }
            if (tokens.getError() == DocoptExitException.class) {
                o.setValue(value != null ? value : Boolean.valueOf(true));
            }
        }
        return Python.list(o);
    }

    private static List<Option> parseShorts(Tokens tokens, List<Option> options) {
        String token = tokens.move();
        assert (token.startsWith("-") && !token.startsWith("--"));
        String left = token.replaceFirst("^-+", "");
        List<Option> parsed = Python.list();
        while (!"".equals(left)) {
            Option o;
            String $short = "-" + left.charAt(0);
            left = left.substring(1);
            List similar = Python.list();
            for (Option o2 : options) {
                if (!$short.equals(o2.getShort())) continue;
                similar.add(o2);
            }
            if (similar.size() > 1) {
                throw tokens.error("%s is specified ambiguously %d times", $short, similar.size());
            }
            if (similar.size() < 1) {
                o = new Option($short, null, 0);
                options.add(o);
                if (tokens.getError() == DocoptExitException.class) {
                    o = new Option($short, null, 0, true);
                }
            } else {
                Option u = (Option)similar.get(0);
                o = new Option($short, u.getLong(), u.getArgCount(), u.getValue());
                String value = null;
                if (o.getArgCount() != 0) {
                    if ("".equals(left)) {
                        String u2 = tokens.current();
                        if (u2 == null || "--".equals(u2)) {
                            throw tokens.error("%s requires argument", $short);
                        }
                        value = tokens.move();
                    } else {
                        value = left;
                        left = "";
                    }
                }
                if (tokens.getError() == DocoptExitException.class) {
                    o.setValue(value != null ? value : Boolean.valueOf(true));
                }
            }
            parsed.add(o);
        }
        return parsed;
    }

    private static Required parsePattern(String source, List<Option> options) {
        Tokens tokens = Tokens.fromPattern(source);
        List<? extends Pattern> result = Docopt.parseExpr(tokens, options);
        if (tokens.current() != null) {
            throw tokens.error("unexpected ending: %s", Python.join(" ", tokens));
        }
        return new Required(result);
    }

    private static List<? extends Pattern> parseExpr(Tokens tokens, List<Option> options) {
        List<Pattern> result;
        List<Pattern> seq = Docopt.parseSeq(tokens, options);
        if (!"|".equals(tokens.current())) {
            return seq;
        }
        List<Pattern> list = result = seq.size() > 1 ? Python.list(new Required(seq)) : seq;
        while ("|".equals(tokens.current())) {
            tokens.move();
            seq = Docopt.parseSeq(tokens, options);
            result.addAll(seq.size() > 1 ? Python.list(new Required(seq)) : seq);
        }
        return result.size() > 1 ? Python.list(new Either(result)) : result;
    }

    private static List<Pattern> parseSeq(Tokens tokens, List<Option> options) {
        List<Pattern> result = Python.list();
        while (!Python.in(tokens.current(), null, "]", ")", "|")) {
            List<? extends Pattern> atom = Docopt.parseAtom(tokens, options);
            if ("...".equals(tokens.current())) {
                atom = Python.list(new OneOrMore(atom));
                tokens.move();
            }
            result.addAll(atom);
        }
        return result;
    }

    private static List<? extends Pattern> parseAtom(Tokens tokens, List<Option> options) {
        String token = tokens.current();
        List<Object> result = Python.list();
        if ("(".equals(token) || "[".equals(token)) {
            String matching;
            tokens.move();
            List<? extends Pattern> u = Docopt.parseExpr(tokens, options);
            if ("(".equals(token)) {
                matching = ")";
                result = Python.list(new Required(u));
            } else if ("[".equals(token)) {
                matching = "]";
                result = Python.list(new Optional(u));
            } else {
                throw new IllegalStateException();
            }
            if (!matching.equals(tokens.move())) {
                throw tokens.error("unmatched '%s'", token);
            }
            return Python.list(result);
        }
        if ("options".equals(token)) {
            tokens.move();
            return Python.list(new OptionsShortcut());
        }
        if (token.startsWith("--") && !"--".equals(token)) {
            return Docopt.parseLong(tokens, options);
        }
        if (token.startsWith("-") && !"-".equals(token) && !"--".equals(token)) {
            return Docopt.parseShorts(tokens, options);
        }
        if (token.startsWith("<") && token.endsWith(">") || Python.isUpper(token)) {
            return Python.list(new Argument(tokens.move()));
        }
        return Python.list(new Command(tokens.move()));
    }

    private static List<LeafPattern> parseArgv(Tokens tokens, List<Option> options, boolean optionsFirst) {
        List<LeafPattern> parsed = Python.list();
        while (tokens.current() != null) {
            if ("--".equals(tokens.current())) {
                for (String v : tokens) {
                    parsed.add(new Argument(null, v));
                }
                return parsed;
            }
            if (tokens.current().startsWith("--")) {
                parsed.addAll(Docopt.parseLong(tokens, options));
                continue;
            }
            if (tokens.current().startsWith("-") && !"-".equals(tokens.current())) {
                parsed.addAll(Docopt.parseShorts(tokens, options));
                continue;
            }
            if (optionsFirst) {
                for (String v : tokens) {
                    parsed.add(new Argument(null, v));
                }
                return parsed;
            }
            parsed.add(new Argument(null, tokens.move()));
        }
        return parsed;
    }

    private static List<Option> parseDefaults(String doc) {
        List<Option> defaults = Python.list();
        for (String s : Docopt.parseSection("options:", doc)) {
            String[] u = Python.partition(s, ":");
            s = u[2];
            List<String> split = Python.Re.split("\\n *(-\\S+?)", "\n" + s);
            split.remove(0);
            List u2 = Python.list();
            for (int i = 1; i < split.size(); i += 2) {
                u2.add(split.get(i - 1) + split.get(i));
            }
            split = u2;
            for (String $s : split) {
                if (!$s.startsWith("-")) continue;
                defaults.add(Option.parse($s));
            }
        }
        return defaults;
    }

    private static List<String> parseSection(String name, String source) {
        List<String> u = Python.Re.findAll("^([^\\n]*" + name + "[^\\n]*\\n?(?:[ \\t].*?(?:\\n|$))*)", source, 11);
        for (int i = 0; i < u.size(); ++i) {
            u.set(i, u.get(i).trim());
        }
        return u;
    }

    private static String formalUsage(String section) {
        String[] u = Python.partition(section, ":");
        section = u[2];
        List<String> pu = Python.split(section);
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        String u2 = pu.remove(0);
        if (!pu.isEmpty()) {
            for (String s : pu) {
                if (s.equals(u2)) {
                    sb.append(") | (");
                } else {
                    sb.append(s);
                }
                sb.append(" ");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(" )");
        return sb.toString();
    }

    private static void extras(boolean help, String version, List<? extends LeafPattern> options, String doc) {
        boolean u = false;
        if (help) {
            for (LeafPattern leafPattern : options) {
                if (!("-h".equals(leafPattern.getName()) | "--help".equals(leafPattern.getName())) || !Python.bool(leafPattern.getValue())) continue;
                u = true;
                break;
            }
        }
        if (u) {
            throw new DocoptExitException(0, doc.replaceAll("^\\n+|\\n+$", ""), false);
        }
        u = false;
        if (Python.bool(version)) {
            for (LeafPattern leafPattern : options) {
                if (!"--version".equals(leafPattern.getName())) continue;
                u = true;
                break;
            }
        }
        if (u) {
            throw new DocoptExitException(0, version, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String read(InputStream stream, String charset) {
        Scanner scanner = new Scanner(stream, charset);
        try {
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        finally {
            scanner.close();
        }
    }

    static String read(InputStream stream) {
        return Docopt.read(stream, "UTF-8");
    }

    public Docopt(String doc) {
        this.doc = doc;
        List<String> usageSections = Docopt.parseSection("usage:", doc);
        if (usageSections.size() == 0) {
            throw new DocoptLanguageError("\"usage:\" (case-insensitive) not found.");
        }
        if (usageSections.size() > 1) {
            throw new DocoptLanguageError("More than one \"usage:\" (case-insensitive).");
        }
        this.usage = usageSections.get(0);
        this.options = Docopt.parseDefaults(doc);
        this.pattern = Docopt.parsePattern(Docopt.formalUsage(this.usage), this.options);
    }

    public Docopt(InputStream stream, Charset charset) {
        this(Docopt.read(stream, charset.displayName()));
    }

    public Docopt(InputStream stream) {
        this(Docopt.read(stream));
    }

    public Docopt withHelp(boolean enabled) {
        this.help = enabled;
        return this;
    }

    public Docopt withVersion(String version) {
        this.version = version;
        return this;
    }

    public Docopt withVersion(InputStream stream, Charset charset) {
        this.version = Docopt.read(stream, charset.displayName());
        return this;
    }

    public Docopt withVersion(InputStream stream) {
        this.version = Docopt.read(stream);
        return this;
    }

    public Docopt withOptionsFirst(boolean enabled) {
        this.optionsFirst = enabled;
        return this;
    }

    public Docopt withExit(boolean enabled) {
        this.exit = enabled;
        return this;
    }

    private Map<String, Object> doParse(List<String> argv) {
        List<LeafPattern> $argv = Docopt.parseArgv(Tokens.withExitException(argv), Python.list(this.options), this.optionsFirst);
        Set<Pattern> patternOptions = Python.set(this.pattern.flat(Option.class));
        for (Pattern optionsShortcut : this.pattern.flat(OptionsShortcut.class)) {
            List<Pattern> u = ((BranchPattern)optionsShortcut).getChildren();
            u.clear();
            u.addAll(Python.set(this.options));
            Object var7_8 = null;
            Iterator<Pattern> i = u.iterator();
            block1: while (i.hasNext()) {
                Pattern pattern = i.next();
                for (Pattern x : patternOptions) {
                    if (!pattern.equals(x)) continue;
                    i.remove();
                    continue block1;
                }
            }
        }
        Docopt.extras(this.help, this.version, $argv, this.doc);
        Pattern.MatchResult m = this.pattern.fix().match($argv);
        if (m.matched() && m.getLeft().isEmpty()) {
            HashMap<String, Object> u = new HashMap<String, Object>();
            for (Pattern pattern : this.pattern.flat(new Class[0])) {
                if (!(pattern instanceof LeafPattern)) {
                    throw new IllegalStateException();
                }
                LeafPattern lp = (LeafPattern)pattern;
                u.put(lp.getName(), lp.getValue());
            }
            for (LeafPattern leafPattern : m.getCollected()) {
                u.put(leafPattern.getName(), leafPattern.getValue());
            }
            return u;
        }
        throw new DocoptExitException(1, null, true);
    }

    public Map<String, Object> parse(List<String> argv) throws DocoptExitException {
        try {
            return this.doParse(argv);
        }
        catch (DocoptExitException e) {
            PrintStream ps;
            if (!this.exit) {
                throw e;
            }
            PrintStream printStream = ps = e.getExitCode() == 0 ? this.out : this.err;
            if (ps != null) {
                String message = e.getMessage();
                if (message != null) {
                    ps.println(message);
                }
                if (e.getPrintUsage()) {
                    ps.println(this.usage);
                }
            }
            System.exit(e.getExitCode());
            throw new IllegalStateException();
        }
    }

    public Map<String, Object> parse(String ... argv) {
        return this.parse(Arrays.asList(argv));
    }

    Docopt withStdOut(PrintStream out) {
        this.out = out;
        return this;
    }

    Docopt withStdErr(PrintStream err) {
        this.err = err;
        return this;
    }
}

