/*
 * Decompiled with CFR 0.152.
 */
package com.noveogroup.debugdrawer;

import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.noveogroup.debugdrawer.BuildConfigDto;
import com.noveogroup.debugdrawer.SupportDebugModule;
import com.noveogroup.debugdrawer.Utils;
import com.noveogroup.debugdrawer.buildinfo.R;
import java.lang.reflect.Field;
import java.util.List;

public class GradleModule
extends SupportDebugModule {
    private final BuildConfigDto helper;
    private TextView gitLabel;
    private TextView dateLabel;
    private TextView flavorLabel;
    private TextView typeLabel;
    private String undefined;

    public GradleModule(Class buildConfigClass) {
        this(new BuildConfigDto(buildConfigClass));
    }

    public GradleModule(String buildSource, String buildDate, String buildFlavor, String buildType) {
        this(new BuildConfigDto(buildSource, buildDate, buildFlavor, buildType));
    }

    private GradleModule(BuildConfigDto buildConfigDto) {
        this.helper = buildConfigDto;
        if (this.helper == null) {
            throw new NullPointerException("buildConfig info not found");
        }
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        View view = inflater.inflate(R.layout.dd_debug_drawer_module_application, parent, false);
        view.setClickable(false);
        view.setEnabled(false);
        this.gitLabel = (TextView)view.findViewById(R.id.dd_debug_application_build_source);
        this.dateLabel = (TextView)view.findViewById(R.id.dd_debug_application_build_date);
        this.flavorLabel = (TextView)view.findViewById(R.id.dd_debug_application_build_flavor);
        this.typeLabel = (TextView)view.findViewById(R.id.dd_debug_application_build_type);
        this.undefined = inflater.getContext().getString(R.string.dd_undefined);
        this.refresh();
        return view;
    }

    public void onOpened() {
        this.refresh();
    }

    public String getDebugInfo() {
        return "Gradle Build Info = {\n  \"git\": " + this.gitLabel.getText() + ",\n  \"date\": " + this.dateLabel.getText() + ",\n  \"flavor\": " + this.flavorLabel.getText() + ",\n  \"type\": " + this.typeLabel.getText() + "\n}";
    }

    private void refresh() {
        this.gitLabel.setText((CharSequence)Utils.firstNonNull((Object[])new String[]{this.helper.getBuildSource(), this.undefined}));
        this.dateLabel.setText((CharSequence)Utils.firstNonNull((Object[])new String[]{this.helper.getBuildDate(), this.undefined}));
        this.flavorLabel.setText((CharSequence)Utils.firstNonNull((Object[])new String[]{this.helper.getBuildFlavor(), this.undefined}));
        this.typeLabel.setText((CharSequence)Utils.firstNonNull((Object[])new String[]{this.helper.getBuildType(), this.undefined}));
    }

    private String findByName(List<Field> fields, String name) {
        try {
            for (Field field : fields) {
                if (!field.getName().equals(name)) continue;
                return (String)field.get(null);
            }
        }
        catch (IllegalAccessException error) {
            throw new IllegalArgumentException("Can't get field " + name, error);
        }
        throw new IllegalArgumentException("Can't find field " + name);
    }
}

