/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.io.Serializable;
import nextapp.echo.app.Extent;

public class Font
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    public static final Typeface SANS_SERIF = new Typeface("Sans-Serif");
    public static final Typeface SERIF = new Typeface("Serif");
    public static final Typeface MONOSPACE = new Typeface("Monospace");
    public static final Typeface HELVETICA = new Typeface("Helvetica", SANS_SERIF);
    public static final Typeface ARIAL = new Typeface("Arial", HELVETICA);
    public static final Typeface VERDANA = new Typeface("Verdana", ARIAL);
    public static final Typeface TIMES = new Typeface("Times", SERIF);
    public static final Typeface TIMES_ROMAN = new Typeface("Times Roman", TIMES);
    public static final Typeface TIMES_NEW_ROMAN = new Typeface("Times New Roman", TIMES_ROMAN);
    public static final Typeface COURIER = new Typeface("Courier", MONOSPACE);
    public static final Typeface COURIER_NEW = new Typeface("Courier New", COURIER);
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int OVERLINE = 8;
    public static final int LINE_THROUGH = 16;
    private Typeface typeface;
    private Extent size;
    private int style;

    public Font(Typeface typeface, int style, Extent size) {
        this.typeface = typeface;
        this.style = style;
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Font)) {
            return false;
        }
        Font that = (Font)o;
        if (this.style != that.style) {
            return false;
        }
        if (this.typeface == null ? that.typeface != null : !this.typeface.equals(that.typeface)) {
            return false;
        }
        return !(this.size == null ? that.size != null : !this.size.equals(that.size));
    }

    public Extent getSize() {
        return this.size;
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isLineThrough() {
        return (this.style & 0x10) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isOverline() {
        return (this.style & 8) != 0;
    }

    public boolean isUnderline() {
        return (this.style & 4) != 0;
    }

    public String toString() {
        StringBuffer out = new StringBuffer(Font.class.getName());
        out.append(" (");
        out.append(this.getTypeface());
        out.append(" /");
        if (this.isPlain()) {
            out.append(" Plain");
        }
        if (this.isBold()) {
            out.append(" Bold");
        }
        if (this.isItalic()) {
            out.append(" Italic");
        }
        if (this.isLineThrough()) {
            out.append(" LineThrough");
        }
        if (this.isOverline()) {
            out.append(" Overline");
        }
        if (this.isUnderline()) {
            out.append(" Underline");
        }
        out.append(" / ");
        out.append(this.getSize());
        out.append(")");
        return out.toString();
    }

    public static class Typeface
    implements Serializable {
        private static final long serialVersionUID = 20070101L;
        private String name;
        private Typeface alternate;

        public Typeface(String name) {
            this(name, null);
        }

        public Typeface(String name, Typeface alternate) {
            if (name == null) {
                throw new IllegalArgumentException("'name' argument cannot be null.");
            }
            this.name = name;
            this.alternate = alternate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Typeface)) {
                return false;
            }
            Typeface that = (Typeface)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (this.alternate == null) {
                return that.alternate == null;
            }
            return this.alternate.equals(that.alternate);
        }

        public Typeface getAlternate() {
            return this.alternate;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.alternate == null ? this.name : this.name + ", " + this.alternate;
        }
    }
}

