/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.Keyword;
import com.networknt.schema.KeywordFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisallowUnknownKeywordFactory
implements KeywordFactory {
    private static final Logger logger = LoggerFactory.getLogger(DisallowUnknownKeywordFactory.class);

    @Override
    public Keyword getKeyword(String value, ValidationContext validationContext) {
        logger.error("Keyword '{}' is unknown and must be configured on the meta-schema or vocabulary", (Object)value);
        throw new InvalidSchemaException(((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Keyword ''{1}'' is unknown and must be configured on the meta-schema or vocabulary")).arguments(value)).build());
    }

    public static DisallowUnknownKeywordFactory getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static DisallowUnknownKeywordFactory INSTANCE = new DisallowUnknownKeywordFactory();

        private Holder() {
        }
    }
}

