/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

final class TagList
implements Iterable<Tag>,
Tag {
    private final String key;
    private final String value;
    private final TagList next;
    private final int hc;
    static final TagList EMPTY = null;

    TagList(String key, String value) {
        this(key, value, EMPTY);
    }

    private TagList(String key, String value, TagList next) {
        this.key = Preconditions.checkNotNull(key, "key");
        this.value = Preconditions.checkNotNull(value, "value");
        this.next = next;
        this.hc = 31 * (key.hashCode() + value.hashCode() + (next == null ? 23 : next.hashCode()));
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public Iterator<Tag> iterator() {
        final TagList root = this;
        return new Iterator<Tag>(){
            private TagList current;
            {
                this.current = root;
            }

            @Override
            public boolean hasNext() {
                return this.current != EMPTY;
            }

            @Override
            public Tag next() {
                if (this.current == EMPTY) {
                    throw new NoSuchElementException();
                }
                TagList tmp = this.current;
                this.current = this.current.next;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TagList)) {
            return false;
        }
        TagList other = (TagList)obj;
        return this.key.equals(other.key) && this.value.equals(other.value) && (this.next == other.next || this.next != null && this.next.equals(other.next));
    }

    public int hashCode() {
        return this.hc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        TagList cur = this.next;
        buf.append(this.key).append('=').append(this.value);
        while (cur != null) {
            buf.append(":").append(cur.key()).append("=").append(cur.value());
            cur = cur.next;
        }
        return buf.toString();
    }

    TagList mergeTag(Tag tag) {
        if (tag == null) {
            return this;
        }
        if (this.next == null) {
            int comparison = this.key.compareTo(tag.key());
            if (comparison == 0) {
                return new TagList(tag.key(), tag.value(), EMPTY);
            }
            if (comparison < 0) {
                return new TagList(this.key, this.value, new TagList(tag.key(), tag.value(), EMPTY));
            }
            return new TagList(tag.key(), tag.value(), this);
        }
        TagSorterAndDeduplicator entries = new TagSorterAndDeduplicator();
        entries.addTags(this);
        entries.addTag(tag);
        return TagList.createFromSortedTags(entries.sortedTags());
    }

    TagList mergeList(Iterable<Tag> tags) {
        if (tags == null) {
            return this;
        }
        Iterator<Tag> iter = tags.iterator();
        if (iter.hasNext()) {
            Tag firstTag = iter.next();
            if (iter.hasNext()) {
                TagSorterAndDeduplicator entries = new TagSorterAndDeduplicator();
                entries.addTags(this);
                entries.addTags(tags);
                return TagList.createFromSortedTags(entries.sortedTags());
            }
            return this.mergeTag(firstTag);
        }
        return this;
    }

    TagList mergeMap(Map<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return this;
        }
        if (tags.size() == 1) {
            Map.Entry<String, String> entry = tags.entrySet().iterator().next();
            return this.mergeTag(new TagList(entry.getKey(), entry.getValue(), EMPTY));
        }
        TagSorterAndDeduplicator entries = new TagSorterAndDeduplicator();
        entries.addTags(this);
        entries.addTags(tags);
        return TagList.createFromSortedTags(entries.sortedTags());
    }

    static TagList create(Iterable<Tag> tags) {
        if (tags == EMPTY || tags instanceof TagList) {
            return (TagList)tags;
        }
        Iterator<Tag> iter = tags.iterator();
        if (iter.hasNext()) {
            Tag firstTag = iter.next();
            if (iter.hasNext()) {
                TagSorterAndDeduplicator entries = new TagSorterAndDeduplicator();
                entries.addTags(tags);
                return TagList.createFromSortedTags(entries.sortedTags());
            }
            return new TagList(firstTag.key(), firstTag.value(), EMPTY);
        }
        return EMPTY;
    }

    static TagList create(Map<String, String> tags) {
        TagList head = EMPTY;
        if (tags.size() >= 2) {
            TagSorterAndDeduplicator entries = new TagSorterAndDeduplicator();
            for (Map.Entry<String, String> t : tags.entrySet()) {
                entries.addTag(new TagList(t.getKey(), t.getValue()));
            }
            head = TagList.createFromSortedTags(entries.sortedTags());
        } else {
            for (Map.Entry<String, String> t : tags.entrySet()) {
                head = new TagList(t.getKey(), t.getValue(), head);
            }
        }
        return head;
    }

    private static TagList createFromSortedTags(Iterable<Tag> sortedTags) {
        TagList head = EMPTY;
        for (Tag t : sortedTags) {
            head = new TagList(t.key(), t.value(), head);
        }
        return head;
    }

    private static class TagSorterAndDeduplicator {
        private static final Comparator<String> REVERSE_STRING_COMPARATOR = (left, right) -> right.compareTo((String)left);
        private final Map<String, Tag> map = new TreeMap<String, Tag>(REVERSE_STRING_COMPARATOR);

        TagSorterAndDeduplicator() {
        }

        void addTag(Tag tag) {
            this.map.put(tag.key(), tag);
        }

        void addTags(Iterable<Tag> tags) {
            for (Tag t : tags) {
                this.map.put(t.key(), t);
            }
        }

        void addTags(Map<String, String> tags) {
            for (Map.Entry<String, String> t : tags.entrySet()) {
                this.map.put(t.getKey(), new TagList(t.getKey(), t.getValue()));
            }
        }

        Iterable<Tag> sortedTags() {
            return this.map.values();
        }
    }
}

