/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;

public final class BasicTag
implements Tag {
    private final String key;
    private final String value;
    private final int hc;

    public BasicTag(String key, String value) {
        this.key = Preconditions.checkNotNull(key, "key");
        this.value = Preconditions.checkNotNull(value, "value");
        this.hc = 31 * key.hashCode() + value.hashCode();
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BasicTag)) {
            return false;
        }
        BasicTag other = (BasicTag)obj;
        return this.key.equals(other.key) && this.value.equals(other.value);
    }

    public int hashCode() {
        return this.hc;
    }

    public String toString() {
        return this.key + '=' + this.value;
    }
}

