/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.dependencybase.tasks;

import com.netflix.nebula.dependencybase.DependencyManagement;
import com.netflix.nebula.dependencybase.tasks.NebulaDependencyInsightReportTask$WhenMappings;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.LegendRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0017R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/netflix/nebula/dependencybase/tasks/NebulaDependencyInsightReportTask;", "Lorg/gradle/api/tasks/diagnostics/DependencyInsightReportTask;", "()V", "reasonLookup", "Lcom/netflix/nebula/dependencybase/DependencyManagement;", "getReasonLookup", "()Lcom/netflix/nebula/dependencybase/DependencyManagement;", "setReasonLookup", "(Lcom/netflix/nebula/dependencybase/DependencyManagement;)V", "calculateCoordinateFromId", "", "id", "", "report", "", "nebula-dependency-base-plugin_main"})
public class NebulaDependencyInsightReportTask
extends DependencyInsightReportTask {
    @Nullable
    private DependencyManagement reasonLookup;

    @Nullable
    public final DependencyManagement getReasonLookup() {
        return this.reasonLookup;
    }

    public final void setReasonLookup(@Nullable DependencyManagement dependencyManagement) {
        this.reasonLookup = dependencyManagement;
    }

    @TaskAction
    public void report() {
        Configuration configuration = this.getConfiguration();
        if (configuration == null) {
            throw (Throwable)new InvalidUserDataException("Dependency insight report cannot be generated because the input configuration was not specified. \nIt can be specified from the command line, e.g: '" + this.getPath() + " --configuration someConf --dependency someDep'");
        }
        Configuration configuration2 = configuration;
        if (this.getDependencySpec() == null) {
            throw (Throwable)new InvalidUserDataException("Dependency insight report cannot be generated because the dependency to show was not specified.\nIt can be specified from the command line, e.g: '" + this.getPath() + " --dependency someDep'");
        }
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        GraphRenderer renderer = new GraphRenderer(output);
        Configuration configuration3 = configuration2;
        if (configuration3 == null) {
            Intrinsics.throwNpe();
        }
        ResolutionResult result = configuration3.getIncoming().getResolutionResult();
        LinkedHashSet selectedDependencies = new LinkedHashSet();
        result.allDependencies((Action)new Action<DependencyResult>(this, selectedDependencies){
            final /* synthetic */ NebulaDependencyInsightReportTask this$0;
            final /* synthetic */ LinkedHashSet $selectedDependencies;

            public final void execute(DependencyResult dependencyResult) {
                if (this.this$0.getDependencySpec().isSatisfiedBy((Object)dependencyResult)) {
                    this.$selectedDependencies.add(dependencyResult);
                }
            }
            {
                this.this$0 = nebulaDependencyInsightReportTask;
                this.$selectedDependencies = linkedHashSet;
            }
        });
        if (selectedDependencies.isEmpty()) {
            output.println((Object)("No dependencies matching given input were found in " + configuration2.toString()));
            return;
        }
        Collection sortedDeps = new DependencyInsightReporter().prepare((Collection)selectedDependencies, this.getVersionSelectorScheme(), this.getVersionComparator());
        NodeRenderer nodeRenderer2 = new NodeRenderer(configuration2){
            final /* synthetic */ Configuration $configuration;

            public final void renderNode(StyledTextOutput target, RenderableDependency node, boolean alreadyRendered) {
                String string;
                boolean leaf = node.getChildren().isEmpty();
                if (leaf) {
                    Configuration configuration = this.$configuration;
                    if (configuration == null) {
                        Intrinsics.throwNpe();
                    }
                    string = configuration.getName();
                } else {
                    string = node.getName();
                }
                target.text((Object)string);
                if (alreadyRendered && !leaf) {
                    target.withStyle(StyledTextOutput.Style.Info).text((Object)" (*)");
                }
            }
            {
                this.$configuration = configuration;
            }
        };
        LegendRenderer legendRenderer = new LegendRenderer(output);
        DependencyGraphRenderer dependencyGraphRenderer = new DependencyGraphRenderer(renderer, nodeRenderer2, legendRenderer);
        int i = 1;
        for (RenderableDependency dependency : sortedDeps) {
            boolean last;
            renderer.visit((Action)new Action<StyledTextOutput>(this, dependency, configuration2){
                final /* synthetic */ NebulaDependencyInsightReportTask this$0;
                final /* synthetic */ RenderableDependency $dependency;
                final /* synthetic */ Configuration $configuration;

                public final void execute(StyledTextOutput out) {
                    CharSequence charSequence;
                    out.withStyle(StyledTextOutput.Style.Identifier).text((Object)this.$dependency.getName());
                    String string = this.$dependency.getDescription();
                    boolean bl = string != null ? (charSequence = (CharSequence)string).length() > 0 : false;
                    if (bl) {
                        String string2;
                        StyledTextOutput styledTextOutput = out.withStyle(StyledTextOutput.Style.Description);
                        StringBuilder stringBuilder = new StringBuilder().append(" (");
                        DependencyManagement dependencyManagement = this.this$0.getReasonLookup();
                        if (dependencyManagement != null) {
                            String string3 = this.$configuration.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"configuration.name");
                            Object object = this.$dependency.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dependency.id");
                            string2 = dependencyManagement.getReason(string3, this.this$0.calculateCoordinateFromId(object));
                        } else {
                            string2 = null;
                        }
                        styledTextOutput.text((Object)stringBuilder.append(string2).append(")").toString());
                    }
                    RenderableDependency.ResolutionState resolutionState = this.$dependency.getResolutionState();
                    if (resolutionState != null) {
                        switch (NebulaDependencyInsightReportTask$WhenMappings.$EnumSwitchMapping$0[resolutionState.ordinal()]) {
                            case 1: {
                                out.withStyle(StyledTextOutput.Style.Failure).text((Object)" FAILED");
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                out.withStyle(StyledTextOutput.Style.Failure).text((Object)" (n)");
                            }
                        }
                    }
                }
                {
                    this.this$0 = nebulaDependencyInsightReportTask;
                    this.$dependency = renderableDependency;
                    this.$configuration = configuration;
                }
            }, true);
            dependencyGraphRenderer.render(dependency);
            if (last = i++ == sortedDeps.size()) continue;
            output.println();
        }
        output.println();
        DependencyManagement dependencyManagement = this.reasonLookup;
        output.println((Object)(dependencyManagement != null ? dependencyManagement.getGlobalMessages() : null));
        legendRenderer.printLegend();
    }

    @NotNull
    public final String calculateCoordinateFromId(@NotNull Object id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Object object = id;
        if (object instanceof ModuleComponentIdentifier) {
            return ((ModuleComponentIdentifier)id).getGroup() + ":" + ((ModuleComponentIdentifier)id).getModule();
        }
        return "";
    }
}

