/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.dependencybase;

import com.netflix.nebula.dependencybase.DependencyManagement;
import com.netflix.nebula.dependencybase.internal.DefaultReason;
import com.netflix.nebula.dependencybase.internal.Force;
import com.netflix.nebula.dependencybase.internal.Lock;
import com.netflix.nebula.dependencybase.internal.Reason;
import com.netflix.nebula.dependencybase.internal.Recommendation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J.\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J&\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J.\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/netflix/nebula/dependencybase/DependencyManagement;", "", "()V", "pluginMessages", "", "", "getPluginMessages", "()Ljava/util/Set;", "reasons", "", "Lcom/netflix/nebula/dependencybase/internal/Reason;", "getReasons", "()Ljava/util/List;", "addForce", "", "configuration", "coordinate", "addLock", "version", "source", "plugin", "addPluginMessage", "", "message", "addReason", "addRecommendation", "getGlobalMessages", "getReason", "nebula-dependency-base-plugin_main"})
public final class DependencyManagement {
    @NotNull
    private final List<Reason> reasons;
    @NotNull
    private final Set<String> pluginMessages;

    @NotNull
    public final List<Reason> getReasons() {
        return this.reasons;
    }

    @NotNull
    public final Set<String> getPluginMessages() {
        return this.pluginMessages;
    }

    public final void addRecommendation(@NotNull String configuration, @NotNull String coordinate, @NotNull String version, @NotNull String source, @NotNull String plugin) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        this.reasons.add(new Recommendation(configuration, coordinate, version, source));
    }

    public final void addLock(@NotNull String configuration, @NotNull String coordinate, @NotNull String version, @NotNull String source, @NotNull String plugin) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        this.reasons.add(new Lock(configuration, coordinate, version, source));
    }

    public final void addForce(@NotNull String configuration, @NotNull String coordinate) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        this.reasons.add(new Force(configuration, coordinate));
    }

    public final void addReason(@NotNull String configuration, @NotNull String coordinate, @NotNull String message, @NotNull String plugin) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        this.reasons.add(new DefaultReason(configuration, coordinate, message));
    }

    public final boolean addPluginMessage(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return this.pluginMessages.add(message);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getReason(@NotNull String configuration, @NotNull String coordinate) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        Iterable iterable = $receiver$iv = (Iterable)this.reasons;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Reason it = (Reason)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getConfiguration(), (Object)configuration) && Intrinsics.areEqual((Object)it.getCoordinate(), (Object)coordinate))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List recs = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        String reason2 = CollectionsKt.joinToString$default((Iterable)recs, null, null, null, (int)0, null, (Function1)getReason.reason.1.INSTANCE, (int)31, null);
        return reason2;
    }

    @NotNull
    public final String getGlobalMessages() {
        Iterable iterable = this.pluginMessages;
        String string = System.lineSeparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.lineSeparator()");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    public DependencyManagement() {
        Collection collection;
        DependencyManagement dependencyManagement = this;
        dependencyManagement.reasons = collection = (List)new ArrayList();
        dependencyManagement = this;
        collection = new LinkedHashSet();
        dependencyManagement.pluginMessages = collection;
    }
}

