/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.dependencybase;

import com.netflix.nebula.dependencybase.DependencyBasePlugin;
import com.netflix.nebula.dependencybase.DependencyManagement;
import com.netflix.nebula.dependencybase.tasks.NebulaDependencyInsightReportTask;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/netflix/nebula/dependencybase/DependencyBasePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "dependencyManagement", "Lcom/netflix/nebula/dependencybase/DependencyManagement;", "apply", "", "project", "enableForceCollection", "initializeDependencyBase", "setupDependencyInsightEnhanced", "nebula-dependency-base-plugin_main"})
public final class DependencyBasePlugin
implements Plugin<Project> {
    private final DependencyManagement dependencyManagement = new DependencyManagement();

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.initializeDependencyBase(project);
        this.enableForceCollection(project);
        this.setupDependencyInsightEnhanced(project);
    }

    private final void initializeDependencyBase(Project project) {
        project.getExtensions().getExtraProperties().set("nebulaDependencyBase", (Object)this.dependencyManagement);
    }

    private final void enableForceCollection(Project project) {
        project.getConfigurations().all((Action)new Action<Configuration>(this){
            final /* synthetic */ DependencyBasePlugin this$0;

            public final void execute(Configuration conf) {
                if (Intrinsics.areEqual((Object)conf.getState(), (Object)Configuration.State.UNRESOLVED)) {
                    conf.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(this, conf){
                        final /* synthetic */ enableForceCollection.1 this$0;
                        final /* synthetic */ Configuration $conf;

                        public final void execute(ResolvableDependencies it) {
                            Set forced = this.$conf.getResolutionStrategy().getForcedModules();
                            Iterable $receiver$iv = forced;
                            for (T element$iv : $receiver$iv) {
                                ModuleVersionSelector force = (ModuleVersionSelector)element$iv;
                                DependencyManagement dependencyManagement = DependencyBasePlugin.access$getDependencyManagement$p(this.this$0.this$0);
                                String string = this.$conf.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"conf.name");
                                dependencyManagement.addForce(string, force.getGroup() + ":" + force.getName());
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$conf = configuration;
                        }
                    });
                }
            }
            {
                this.this$0 = dependencyBasePlugin;
            }
        });
    }

    private final void setupDependencyInsightEnhanced(Project project) {
        NebulaDependencyInsightReportTask depInsightEnhancedTask = (NebulaDependencyInsightReportTask)project.getTasks().create("dependencyInsightEnhanced", NebulaDependencyInsightReportTask.class);
        depInsightEnhancedTask.setReasonLookup(this.dependencyManagement);
    }

    @NotNull
    public static final /* synthetic */ DependencyManagement access$getDependencyManagement$p(DependencyBasePlugin $this) {
        return $this.dependencyManagement;
    }
}

