/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.user;

import android.content.Context;
import android.util.Log;
import com.netease.nis.bugrpt.tool.AppInfo;
import com.netease.nis.bugrpt.tool.CacheHelper;
import com.netease.nis.bugrpt.tool.Common;
import com.netease.nis.bugrpt.tool.LRULinkedHashMap;
import com.netease.nis.bugrpt.user.IExceptionCallback;
import java.util.LinkedList;
import java.util.Map;
import org.json.JSONObject;

public class UserStrategy {
    private String mChannel = "";
    private String mUserId = "";
    private String mUserTag = "";
    private String mScene = "";
    private String mUserAppID = "";
    private String mVerSuffix = "";
    private IExceptionCallback mCallback = null;
    private boolean bMonitorAnr = true;
    private boolean bMonitorNdkCrash = true;
    private Map<String, String> mParamMap = new LRULinkedHashMap<String, String>(20);
    private LinkedList<String> mTrackLog = new LinkedList();
    private int mMaxBreadcrumbCount = 500;

    public UserStrategy(Context context) {
    }

    public String getChannel() {
        return this.mChannel;
    }

    public void setChannel(String channel) {
        if (channel != null) {
            this.mChannel = channel;
        }
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String uid) {
        String userId = uid;
        if (userId != null) {
            this.mUserId = Common.truncateUserInput(userId, 64);
        }
    }

    public String getScene() {
        return this.mScene;
    }

    public void setScene(String sc) {
        String scene = sc;
        if (scene != null) {
            this.mScene = Common.truncateUserInput(scene, 48);
        }
    }

    public String getAppId() {
        return this.mUserAppID;
    }

    public void setAppId(String appid) {
        if (appid != null) {
            this.mUserAppID = appid;
        }
    }

    public void setDelayTime(long time) {
        CacheHelper.getInstance().setDelayTime(time);
    }

    public String getUserTag() {
        return this.mUserTag;
    }

    public void setUserTag(String tag) {
        if (tag != null) {
            if (this.mUserTag == null || this.mUserTag.equals("")) {
                this.mUserTag = tag;
            } else if (!this.mUserTag.contains(tag)) {
                this.mUserTag = this.mUserTag + " " + tag;
            }
            this.mUserTag = Common.truncateUserInput(this.mUserTag, 48);
        }
    }

    public String getTrackLog() {
        StringBuilder strTracklog = new StringBuilder();
        for (String item : this.mTrackLog) {
            strTracklog.append(item);
        }
        return strTracklog.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendTrackLog(String info) {
        UserStrategy userStrategy = this;
        synchronized (userStrategy) {
            String[] msgList;
            for (String msg : msgList = info.split("\n")) {
                if (Common.isNullOrNil(msg)) continue;
                this.appendSingleTrackLog(msg);
            }
        }
    }

    private void appendSingleTrackLog(String info) {
        if (info != null && this.mTrackLog != null) {
            StringBuilder finalLog = Common.generateLogSuffix();
            String msg = Common.truncateUserInput(info, 200);
            finalLog.append(msg);
            finalLog.append("\n");
            Log.d((String)"bugrpt", (String)finalLog.toString());
            if (this.mTrackLog.size() >= this.mMaxBreadcrumbCount) {
                this.mTrackLog.removeFirst();
                Log.d((String)"bugrpt", (String)"size is full,remove first");
            }
            this.mTrackLog.add(finalLog.toString());
        }
    }

    public boolean isAnrMonitored() {
        return this.bMonitorAnr;
    }

    public void setAnrMonitorStatus(boolean bMonitor) {
        this.bMonitorAnr = bMonitor;
    }

    public boolean isNdkCrashMonitored() {
        return this.bMonitorNdkCrash;
    }

    public void setCollectNdkCrash(boolean bMonitor) {
        this.bMonitorNdkCrash = bMonitor;
    }

    public void addUserDefinedParam(String key, String val) {
        if (this.mParamMap == null || key == null || val == null || key.length() > 50) {
            return;
        }
        if (!key.matches("[a-zA-Z[0-9]_-]+")) {
            Log.d((String)"bugrpt", (String)("key not valid:" + key));
            return;
        }
        String value = Common.truncateUserInput(val, 200);
        this.mParamMap.put(key, value);
    }

    public JSONObject getUserDefineParam() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.mParamMap != null) {
                Map<String, String> userParamMap = this.mParamMap;
                for (Map.Entry<String, String> entry : userParamMap.entrySet()) {
                    Log.d((String)"bugrpt", (String)("Key = " + entry.getKey() + ", Value = " + entry.getValue()));
                    jsonObject.put(entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject;
    }

    public void setVersionSuffix(String suffix) {
        this.mVerSuffix = suffix;
    }

    public String getVersionSuffix() {
        return this.mVerSuffix;
    }

    public void setUserUncaughtExceptionCallback(IExceptionCallback callback) {
        if (callback != null) {
            this.mCallback = callback;
        }
    }

    public void dealUserUncaughtExceptionCallback(Thread thread, Throwable ex) {
        if (this.mCallback != null) {
            this.mCallback.uncaughtException(thread, ex);
        }
    }

    public String getAppVersion(Context ctx) {
        String appVer = "";
        try {
            StringBuilder versionBuilder = new StringBuilder();
            AppInfo appInfo = new AppInfo();
            versionBuilder.append(appInfo.getVersionName(ctx));
            String mVerSuffix = this.getVersionSuffix();
            if (!mVerSuffix.equals("")) {
                versionBuilder.append("_").append(mVerSuffix);
            }
            appVer = versionBuilder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appVer;
    }

    public String getAppID(Context ctx) {
        String appid = this.getAppId();
        if (appid.equals("")) {
            AppInfo appinfo = new AppInfo();
            appid = appinfo.getAppID(ctx);
        }
        Log.d((String)"bugrpt", (String)("Appid:" + appid));
        return appid;
    }

    public void setBreadcrumbCount(int nMaxCount) {
        if (nMaxCount >= 0 && nMaxCount < this.mMaxBreadcrumbCount) {
            this.mMaxBreadcrumbCount = nMaxCount;
        }
    }
}

