/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.content.Context;
import android.util.Log;
import com.netease.nis.bugrpt.CrashHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExtroInfo {
    private static final int maxStackSize = 15000;
    private static final int maxSysLogSize = 25000;

    public static JSONArray getAllThreadStack() {
        JSONArray retArray = new JSONArray();
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        if (allStackTraces == null) {
            return retArray;
        }
        Log.d((String)"bugrpt", (String)("totoal thread number:" + allStackTraces.size()));
        try {
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                StackTraceElement[] array = entry.getValue();
                if (array == null || array.length == 0) continue;
                JSONObject jsonObject = new JSONObject();
                StringBuffer sbStack = new StringBuffer("");
                for (StackTraceElement stackTraceElement : array) {
                    if (sbStack.length() >= 15000) {
                        sbStack.append("\n[Stack is too long,has been truncated!]");
                        break;
                    }
                    sbStack.append(stackTraceElement.toString());
                    sbStack.append("\n");
                }
                jsonObject.put("id", entry.getKey().getId());
                jsonObject.put("name", (Object)entry.getKey().getName());
                jsonObject.put("stack", (Object)sbStack.toString());
                retArray.put((Object)jsonObject);
            }
        }
        catch (Exception e) {
            CrashHandler.leaveBreadcrumb("getAllThreadStack:" + e.toString());
        }
        return retArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSyslog(Context ctx, String exec) {
        String[] cmdList = exec == null ? new String[]{"logcat", "-d", "-v", "threadtime"} : new String[]{"logcat", "-d", "-v", "threadtime", "-s", exec};
        Process proc = null;
        StringBuilder strSysLog = new StringBuilder();
        try {
            String retLog;
            BufferedReader reader;
            int pid = android.os.Process.myPid();
            String strPid = "" + pid;
            String packageName = "";
            if (ctx != null) {
                packageName = ctx.getPackageName();
            }
            if ((reader = new BufferedReader(new InputStreamReader((proc = Runtime.getRuntime().exec(cmdList)).getInputStream()))) != null) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!ExtroInfo.isLogContainsTag(line, strPid) && !ExtroInfo.isLogContainsTag(line, packageName)) continue;
                    strSysLog.append(line).append("\n");
                    if (strSysLog.length() <= 25000) continue;
                    strSysLog.delete(0, strSysLog.length() - 25000);
                }
                reader.close();
            }
            String string = retLog = ExtroInfo.getFormatLog(strSysLog.toString());
            return string;
        }
        catch (Throwable t) {
            String string = strSysLog.append("\n[error:" + t.toString() + "]").toString();
            return string;
        }
        finally {
            if (proc != null) {
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
    }

    private static boolean isLogContainsTag(String line, String tag) {
        return tag.equals("") || line.contains(tag);
    }

    private static String getFormatLog(String strLog) {
        String fmtLog = strLog;
        if (fmtLog.length() < 6) {
            return "";
        }
        if (fmtLog.charAt(2) == '-' && fmtLog.charAt(5) == ' ') {
            Log.d((String)"bugrpt", (String)"Log is valid");
        } else {
            int index = fmtLog.indexOf(10);
            if (index != -1) {
                return fmtLog.substring(index + 1);
            }
        }
        return fmtLog;
    }
}

