/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.netease.nis.bugrpt.NativeCrashHandler;
import com.netease.nis.bugrpt.tool.AppInfo;
import com.netease.nis.bugrpt.tool.Common;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.UUID;
import org.json.JSONObject;

public class DeviceInfo {
    public static final String INVALID_ANDROID_ID = "9774d56d682e549c";
    private String imei = "";
    private String osversion = "";
    private String androidId = "";
    private String macAddress = "";
    private String model = "";
    private String daid = "";

    public static String getCpuList(Object value) {
        StringBuffer tempret = new StringBuffer("");
        try {
            String[] list;
            int idx = 0;
            for (String item : list = (String[])value) {
                tempret.append(item);
                if (++idx == list.length) continue;
                tempret.append(',');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tempret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuAbi() {
        String cpuAbi = "";
        String filePath = "/system/build.prop";
        BufferedReader br = null;
        FileReader inputStreamReader = null;
        if (Common.checkFileExist(filePath)) {
            try {
                String tempCpuAbi = null;
                String line = "";
                inputStreamReader = new FileReader(filePath);
                br = new BufferedReader(inputStreamReader, 2048);
                while ((line = br.readLine()) != null) {
                    String[] split = line.split("=", 2);
                    if (split.length != 2) continue;
                    if (split[0].equals("ro.product.cpu.abilist")) {
                        tempCpuAbi = split[1];
                        break;
                    }
                    if (!split[0].equals("ro.product.cpu.abi")) continue;
                    tempCpuAbi = split[1];
                    break;
                }
                if (tempCpuAbi != null) {
                    cpuAbi = tempCpuAbi.split(",")[0];
                }
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception fnfe) {}
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception fnfe) {}
                }
            }
        }
        return cpuAbi;
    }

    public String getImei(Context ctx) {
        if (null == this.imei || this.imei.equals("")) {
            try {
                this.imei = ((TelephonyManager)ctx.getSystemService("phone")).getDeviceId();
            }
            catch (Exception e) {
                this.imei = "";
            }
        }
        return this.imei;
    }

    public String getserial() {
        String serial = "";
        try {
            serial = Build.SERIAL;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serial;
    }

    public String getOsVersion() {
        if (null == this.osversion || this.osversion.equals("")) {
            try {
                this.osversion = Build.VERSION.RELEASE;
            }
            catch (Exception e) {
                this.osversion = "";
            }
        }
        return this.osversion;
    }

    public String getModel() {
        if (null == this.model || this.model.equals("")) {
            try {
                this.model = Build.MODEL;
            }
            catch (Exception e) {
                this.model = "";
            }
        }
        return this.model;
    }

    public String getFingerprint() {
        String fingerprint = "";
        try {
            fingerprint = Build.FINGERPRINT;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fingerprint;
    }

    public String getAndroid_id(Context ctx) {
        if (null == this.androidId || this.androidId.equals("")) {
            try {
                this.androidId = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id");
            }
            catch (Exception e) {
                this.androidId = "";
            }
        }
        return this.androidId;
    }

    public String getCompany() {
        String company = "";
        try {
            company = Build.MANUFACTURER;
        }
        catch (Exception e) {
            company = "";
        }
        return company;
    }

    public String getDeviceType(Context ctx) {
        String deviceType = "";
        deviceType = this.isTablet(ctx) ? "Tablet" : "phone";
        return deviceType;
    }

    public String getDeviceID(Context ctx) {
        String deviceID = "";
        try {
            deviceID = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deviceID;
    }

    public String getOpenUDID(Context ctx) {
        String OpenUDID = "";
        OpenUDID = this.getImei(ctx);
        if ((null == OpenUDID || OpenUDID.equals("")) && (null == (OpenUDID = this.getAndroid_id(ctx)) || OpenUDID.toLowerCase().equals(INVALID_ANDROID_ID) || OpenUDID.equals("")) && (OpenUDID = this.getserial()).equals("") && (null == (OpenUDID = this.getMacAdderss(ctx)) || OpenUDID.equals(""))) {
            OpenUDID = this.generateOpenUDID(ctx);
        }
        return OpenUDID;
    }

    public String getNetworkType(Context ctx) {
        String netType = "unknown";
        try {
            TelephonyManager telephonyManager;
            NetworkInfo activeNetworkInfo = ((ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo();
            if (activeNetworkInfo == null) {
                return netType;
            }
            if (activeNetworkInfo.getType() == 1) {
                netType = "WIFI";
            } else if (activeNetworkInfo.getType() == 0 && (telephonyManager = (TelephonyManager)ctx.getSystemService("phone")) != null) {
                int networkType = telephonyManager.getNetworkType();
                switch (networkType) {
                    case 1: {
                        netType = "GPRS";
                        break;
                    }
                    case 2: {
                        netType = "EDGE";
                        break;
                    }
                    case 3: {
                        netType = "UMTS";
                        break;
                    }
                    case 8: {
                        netType = "HSDPA";
                        break;
                    }
                    case 9: {
                        netType = "HSUPA";
                        break;
                    }
                    case 10: {
                        netType = "HSPA";
                        break;
                    }
                    case 4: {
                        netType = "CDMA";
                        break;
                    }
                    case 5: {
                        netType = "EVDO_0";
                        break;
                    }
                    case 6: {
                        netType = "EVDO_A";
                        break;
                    }
                    case 7: {
                        netType = "1xRTT";
                        break;
                    }
                    case 11: {
                        netType = "iDen";
                        break;
                    }
                    case 12: {
                        netType = "EVDO_B";
                        break;
                    }
                    case 13: {
                        netType = "LTE";
                        break;
                    }
                    case 14: {
                        netType = "eHRPD";
                        break;
                    }
                    case 15: {
                        netType = "HSPA+";
                        break;
                    }
                    default: {
                        netType = "MOBILE(" + networkType + ")";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return netType;
    }

    public String getMacAdderss(Context ctx) {
        if (null == this.androidId || this.macAddress.equals("")) {
            try {
                WifiManager wifiManager = (WifiManager)ctx.getSystemService("wifi");
                this.macAddress = wifiManager.getConnectionInfo().getMacAddress();
                if (this.macAddress != null) {
                    this.macAddress = this.macAddress.toLowerCase();
                }
            }
            catch (Exception e) {
                this.macAddress = "";
            }
        }
        return this.macAddress;
    }

    public String getSimCarrier(Context ctx) {
        String simCarrier = "unknown";
        try {
            TelephonyManager tManager = (TelephonyManager)ctx.getSystemService("phone");
            String IMSI = tManager.getSubscriberId();
            simCarrier = IMSI.startsWith("46000") ? "\u4e2d\u56fd\u79fb\u52a8" : (IMSI.startsWith("46002") ? "\u4e2d\u56fd\u79fb\u52a8" : (IMSI.startsWith("46001") ? "\u4e2d\u56fd\u8054\u901a" : (IMSI.startsWith("46003") ? "\u4e2d\u56fd\u7535\u4fe1" : "unknown")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return simCarrier;
    }

    public String getDaid(Context ctx) {
        if (null == this.daid || this.daid.equals("")) {
            try {
                String imei = this.getImei(ctx);
                String androidId = this.getAndroid_id(ctx);
                String macAddr = this.getMacAdderss(ctx);
                String model = this.getModel();
                if (imei == null) {
                    imei = "";
                }
                if (androidId == null || androidId.toLowerCase().equals(INVALID_ANDROID_ID)) {
                    androidId = "";
                }
                if (macAddr == null) {
                    macAddr = "";
                }
                if (model == null) {
                    model = "";
                }
                this.daid = this.SHA(imei + androidId + macAddr + model);
            }
            catch (Exception e) {
                this.daid = "";
            }
        }
        return this.daid;
    }

    public JSONObject getMemoryInfo(Context ctx) {
        JSONObject jminfo = new JSONObject();
        try {
            long sdTotalSize = this.getTotalSdCardSize();
            long sdAvailSize = this.getAvailSdCardSize();
            long ROMTotalSize = this.getTotalROMSize();
            long ROMAvailSize = this.getAvailROMSize();
            long RAMTotalSize = this.getTotalRAMSize();
            long RAMAvailSize = this.getAvailRAMSize(ctx);
            jminfo.put("SDCard_TotalSize", (Object)this.formatMemorySize(sdTotalSize));
            jminfo.put("SDCard_AvailSize", (Object)this.formatMemorySize(sdAvailSize));
            jminfo.put("InnerStorage_TotalSize", (Object)this.formatMemorySize(ROMTotalSize));
            jminfo.put("InnerStorage_AvailSize", (Object)this.formatMemorySize(ROMAvailSize));
            jminfo.put("RAM_TotalSize", (Object)this.formatMemorySize(RAMTotalSize));
            jminfo.put("RAM_AvailSize", (Object)this.formatMemorySize(RAMAvailSize));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jminfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getStatInfo() {
        BufferedReader bReader = null;
        long[] stat = new long[]{0L, 0L};
        try {
            bReader = new BufferedReader(new FileReader("/proc/stat"));
            String strTemp = bReader.readLine();
            String[] listStrings = strTemp.split(" ");
            long user = Long.parseLong(listStrings[2]);
            long nice = Long.parseLong(listStrings[3]);
            long sys = Long.parseLong(listStrings[4]);
            long idle = Long.parseLong(listStrings[5]);
            long iowait = Long.parseLong(listStrings[6]);
            long irq = Long.parseLong(listStrings[7]);
            long softirq = Long.parseLong(listStrings[8]);
            stat[0] = user + nice + sys + idle + iowait + irq + softirq;
            stat[1] = idle;
        }
        catch (Exception exception) {
        }
        finally {
            if (bReader != null) {
                try {
                    bReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return stat;
    }

    public String getCpuUsage() {
        String strCpuUsage = "";
        float mCpuUsage = 0.0f;
        try {
            long[] statInfoStart = this.getStatInfo();
            Common.sleep(500L);
            long[] statInfoEnd = this.getStatInfo();
            mCpuUsage = (float)(statInfoEnd[0] - statInfoStart[0] - (statInfoEnd[1] - statInfoStart[1])) / (float)(statInfoEnd[0] - statInfoStart[0]) * 100.0f;
            if (mCpuUsage < 0.0f) {
                mCpuUsage = 0.0f;
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            strCpuUsage = decimalFormat.format(mCpuUsage) + "%";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strCpuUsage;
    }

    public boolean isRoot() {
        String binPath = "/system/bin/su";
        String xBinPath = "/system/xbin/su";
        return new File(binPath).exists() && this.isExecutable(binPath) || new File(xBinPath).exists() && this.isExecutable(xBinPath);
    }

    private boolean isSdCardExist() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private long getTotalSdCardSize() {
        if (!this.isSdCardExist()) {
            return -1L;
        }
        long totalSdSize = -2L;
        try {
            StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
            totalSdSize = this.getStatFsTotalSize(statFs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalSdSize;
    }

    private long getAvailSdCardSize() {
        if (!this.isSdCardExist()) {
            return -1L;
        }
        long availSdSize = -2L;
        try {
            StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
            availSdSize = this.getSataFsAvailSize(statFs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return availSdSize;
    }

    private long getTotalROMSize() {
        long totalROMSize = -2L;
        try {
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            totalROMSize = this.getStatFsTotalSize(statFs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalROMSize;
    }

    private long getAvailROMSize() {
        long availROMSize = -2L;
        try {
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            availROMSize = this.getSataFsAvailSize(statFs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return availROMSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTotalRAMSize() {
        String mem_path = "/proc/meminfo";
        FileReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            reader = new FileReader("/proc/meminfo");
            bufferedReader = new BufferedReader(reader, 8192);
            long l = Long.parseLong(bufferedReader.readLine().split("\\s+")[1]) * 1024L;
            return l;
        }
        catch (Exception e) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    ((InputStreamReader)reader).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    ((InputStreamReader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return -2L;
    }

    private long getAvailRAMSize(Context context) {
        long availRAMsize = -2L;
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            am.getMemoryInfo(memInfo);
            availRAMsize = memInfo.availMem;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return availRAMsize;
    }

    private long getStatFsTotalSize(StatFs statFs) {
        long statFstotalSize = -2L;
        try {
            if (Build.VERSION.SDK_INT > 17) {
                long counts = statFs.getBlockCountLong();
                long size = statFs.getBlockSizeLong();
                statFstotalSize = counts * size;
            } else {
                long counts = statFs.getBlockCount();
                long size = statFs.getBlockSize();
                statFstotalSize = counts * size;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return statFstotalSize;
    }

    private long getSataFsAvailSize(StatFs statFs) {
        long statFsAvailSize = -2L;
        try {
            if (Build.VERSION.SDK_INT > 17) {
                long counts = statFs.getAvailableBlocksLong();
                long size = statFs.getBlockSizeLong();
                statFsAvailSize = counts * size;
            } else {
                long counts = statFs.getAvailableBlocks();
                long size = statFs.getBlockSize();
                statFsAvailSize = counts * size;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return statFsAvailSize;
    }

    private String formatMemorySize(long size) {
        if (size < 0L) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        String fileSizeString = "0";
        fileSizeString = df.format((double)size / 1048576.0);
        return fileSizeString;
    }

    private String SHA(String toConvert) {
        String SHAnum = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(toConvert.getBytes("UTF-8"));
            BigInteger hashedNumber = new BigInteger(1, digest);
            SHAnum = hashedNumber.toString(16);
        }
        catch (Exception e) {
            SHAnum = toConvert;
        }
        return SHAnum;
    }

    private String generateOpenUDID(Context mContext) {
        String OpenUDID = "";
        try {
            SharedPreferences preferences = mContext.getSharedPreferences("OpenUdid", 0);
            OpenUDID = preferences.getString("OpenUdid", "");
            if (OpenUDID.equals("")) {
                String UDID = UUID.randomUUID().toString();
                SharedPreferences.Editor editor = preferences.edit();
                editor.putString("OpenUdid", UDID);
                editor.commit();
                OpenUDID = UDID;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OpenUDID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecutable(String filePath) {
        Process process = null;
        try {
            char flag;
            process = Runtime.getRuntime().exec("ls -l " + filePath);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String str = in.readLine();
            if (str != null && str.length() >= 4 && ((flag = str.charAt(3)) == 's' || flag == 'x')) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (process != null) {
                try {
                    process.destroy();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public String getResolution(Context context) {
        StringBuffer resolution = new StringBuffer("");
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            DisplayMetrics metric = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metric);
            int width = metric.widthPixels;
            int height = metric.heightPixels;
            resolution.append(Integer.toString(width)).append("x").append(Integer.toString(height));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resolution.toString();
    }

    public int getOrientation(Context context) {
        Configuration cf = context.getResources().getConfiguration();
        int ori = cf.orientation;
        if (ori == 2) {
            return 1;
        }
        if (ori == 1) {
            return 0;
        }
        return -1;
    }

    public boolean getBuildProperty(JSONObject info, Context ctx) {
        boolean bJni = false;
        String strjson = null;
        try {
            String strVer = Build.VERSION.RELEASE;
            info.put("OSVERSION", (Object)strVer);
            Field[] fields = Build.class.getDeclaredFields();
            if (fields == null) {
                return false;
            }
            for (Field field : fields) {
                field.setAccessible(true);
                String key = field.getName();
                String value = field.get(null).toString();
                if (key.equalsIgnoreCase("SUPPORTED_32_BIT_ABIS") || key.equalsIgnoreCase("SUPPORTED_64_BIT_ABIS") || key.equalsIgnoreCase("SUPPORTED_ABIS")) {
                    value = DeviceInfo.getCpuList(field.get(null));
                } else if (key.equalsIgnoreCase("MODEL") && value != null && value.length() > 32) {
                    value = value.substring(0, 31);
                }
                if (value == null || value.equalsIgnoreCase("null")) {
                    JSONObject jniInfo;
                    if (!bJni) {
                        bJni = true;
                        strjson = NativeCrashHandler.collectJniDeviceInfo(ctx, null);
                    }
                    if (strjson == null || strjson.length() <= 0 || !(jniInfo = new JSONObject(strjson)).has(key)) continue;
                    info.put(key, (Object)jniInfo.getString(key));
                    continue;
                }
                info.put(key, (Object)value);
            }
            String cpuType = DeviceInfo.getCpuAbi();
            if (cpuType != "") {
                info.put("CPU_ABI", (Object)DeviceInfo.getCpuAbi());
                Log.d((String)"bugrpt", (String)("cpu:" + cpuType));
            }
            info.put("CPU_ABI2", (Object)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bJni;
    }

    public static JSONObject collectDeviceInfo(Context ctx, long startTime) {
        JSONObject info = new JSONObject();
        boolean flag = false;
        try {
            DeviceInfo mdeviceInfo;
            info.put("OS", (Object)"android");
            info.put("STARTTIME", startTime);
            info.put("CRASHTIME", System.currentTimeMillis());
            AppInfo appInfo = new AppInfo();
            if (appInfo != null) {
                String fileHash = appInfo.getFileHash(ctx);
                info.put("FILEHASH", (Object)fileHash);
            }
            if ((mdeviceInfo = new DeviceInfo()) != null) {
                String iMei = mdeviceInfo.getImei(ctx);
                info.put("IMEI", (Object)iMei);
                String deviceID = mdeviceInfo.getDeviceID(ctx);
                info.put("DEVICEID", (Object)deviceID);
                flag = mdeviceInfo.getBuildProperty(info, ctx);
                if (flag) {
                    info.put("java", (Object)"fail");
                }
                JSONObject jminfo = mdeviceInfo.getMemoryInfo(ctx);
                info.put("MemoryInfo", (Object)jminfo);
                String cpuUsage = mdeviceInfo.getCpuUsage();
                info.put("CpuUsage", (Object)cpuUsage);
                boolean isRoot = false;
                String strRoot = NativeCrashHandler.isRoot(ctx, null);
                if (null == strRoot || strRoot.equals("")) {
                    isRoot = mdeviceInfo.isRoot();
                } else {
                    if (strRoot.compareTo("True") == 0) {
                        isRoot = true;
                    }
                    if (strRoot.compareTo("False") == 0) {
                        isRoot = false;
                    }
                }
                info.put("IsRoot", isRoot);
                info.put("RESOLUTION", (Object)mdeviceInfo.getResolution(ctx));
                info.put("DIRECTION", mdeviceInfo.getOrientation(ctx));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }
}

