/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.util.Log;
import android.util.Pair;
import com.netease.nis.bugrpt.user.AbstractNetClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class DefaultHttpClient
implements AbstractNetClient {
    @Override
    public Pair<Integer, String> send(String url, String data, int timeout) {
        Pair retPair = null;
        try {
            long start = System.nanoTime();
            byte[] entity = data.getBytes();
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(entity.length));
            OutputStream outStream = conn.getOutputStream();
            outStream.write(entity);
            String result = this.getResponseResult(conn.getInputStream());
            int responseCode = conn.getResponseCode();
            retPair = new Pair((Object)responseCode, (Object)result);
            Log.d((String)"bugrpt", (String)("code:" + responseCode + " result:" + result));
            long elapsed = System.nanoTime() - start;
            Log.d((String)"bugrpt", (String)("Elapsed time (ms): " + elapsed / 1000000L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retPair;
    }

    private String getResponseResult(InputStream inputStream) {
        String resultData = "";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(data)) != -1) {
                byteArrayOutputStream.write(data, 0, len);
            }
            resultData = new String(byteArrayOutputStream.toByteArray());
            inputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultData;
    }
}

