/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.crash.anr;

import android.app.ActivityManager;
import android.content.Context;
import android.os.FileObserver;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.netease.nis.bugrpt.CrashHandler;
import com.netease.nis.bugrpt.crash.CrashDetailBean;
import com.netease.nis.bugrpt.crash.anr.AnrWatchThread;
import com.netease.nis.bugrpt.tool.Common;
import com.netease.nis.bugrpt.tool.ExtroInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnrMonitor {
    private static final int MESSAGE_ANR_CATCHER = 100;
    private static final String TRACE_DIR = "/data/anr/";
    public Context mCtx = null;
    public FileObserver mfo = null;
    public long mLastAnrTime = 0L;
    private HandlerThread mHandleThread = null;
    private Handler mHandler = null;
    private boolean mbStartWatchThread = true;
    private AnrWatchThread mWatchThread = null;

    public AnrMonitor(Context ctx) {
        this.mCtx = ctx;
    }

    public void startMonitorANR() {
        this.mfo = new FileObserver(TRACE_DIR, 8){

            public void onEvent(int i, String s) {
                if (s == null) {
                    return;
                }
                String filePath = AnrMonitor.TRACE_DIR + s;
                if (!filePath.contains("trace")) {
                    Log.d((String)"bugrpt", (String)("not anr file " + filePath));
                    return;
                }
                AnrMonitor.this.onNotifyAnrEvent(filePath);
            }
        };
        try {
            this.mHandleThread = new HandlerThread("anr_monitor");
            this.mHandleThread.start();
            this.mHandler = new THandler(this.mHandleThread.getLooper());
            if (this.mbStartWatchThread) {
                this.mWatchThread = new AnrWatchThread(this);
                this.mWatchThread.start();
            }
            if (this.mfo != null) {
                this.mfo.startWatching();
                Log.d((String)"bugrpt", (String)"start anr monitor!");
            }
        }
        catch (Throwable t) {
            this.mfo = null;
            Log.d((String)"bugrpt", (String)"start anr monitor failed!");
        }
    }

    public void stopMonitorANR() {
        try {
            if (this.mfo != null) {
                this.mfo.stopWatching();
                this.mfo = null;
            }
            if (this.mWatchThread != null) {
                this.mWatchThread.interrupt();
            }
            this.mHandleThread.quit();
            this.mHandleThread = null;
            this.mHandler = null;
            this.mCtx = null;
            Log.d((String)"bugrpt", (String)"stop anr monitor!");
        }
        catch (Throwable t) {
            Log.d((String)"bugrpt", (String)("stop anr monitor failed! " + t.toString()));
        }
    }

    public void onNotifyAnrEvent(String path) {
        if (this.mHandler != null) {
            this.mHandler.obtainMessage(100, (Object)path).sendToTarget();
        }
    }

    protected void dealWithANR(String tracePath) {
        TraceUtil tracer = new TraceUtil();
        if (!this.parseTrace(tracePath, tracer)) {
            Log.d((String)"bugrpt", (String)"parseTrace failed");
            return;
        }
        long anrTime = tracer.time;
        if (anrTime == 0L) {
            anrTime = System.currentTimeMillis();
        }
        if (this.mLastAnrTime != 0L && Math.abs(this.mLastAnrTime - anrTime) < 10000L) {
            Log.d((String)"bugrpt", (String)"too frequent");
            return;
        }
        this.mLastAnrTime = anrTime;
        String anrThreadStack = "";
        ActivityManager.ProcessErrorStateInfo procStat = this.getProcessErrorStateInfo(this.mCtx, 10000L);
        if (procStat != null) {
            if (procStat.pid == Process.myPid()) {
                Log.d((String)"bugrpt", (String)("ANR pid:" + procStat.pid + "\nshortMsg:" + procStat.shortMsg + "\nlongMsg:" + procStat.longMsg + "\nprocessName:" + procStat.processName));
                try {
                    JSONArray threadStack = ExtroInfo.getAllThreadStack();
                    for (int i = 0; i < threadStack.length(); ++i) {
                        JSONObject obj = (JSONObject)threadStack.get(i);
                        String strThreadName = obj.getString("name");
                        if (!strThreadName.startsWith("main")) continue;
                        anrThreadStack = obj.getString("stack");
                        String reason = this.getAnrReason(procStat);
                        Log.d((String)"bugrpt", (String)("anr reason:" + reason));
                        StringBuilder tempanrStack = new StringBuilder();
                        tempanrStack.append(reason).append(":").append(procStat.shortMsg).append("\n").append(anrThreadStack);
                        String anrStack = tempanrStack.toString();
                        CrashDetailBean bean = new CrashDetailBean(anrStack).setPlatformTag("java").setExceptionType("anr").setAnrMsg(procStat.longMsg).setAnrTraceInfo(tracer.threadMap).setAllThreadStack(threadStack);
                        CrashHandler.getInstance().asySendReportToServer(bean);
                    }
                }
                catch (JSONException jSONException) {}
            } else {
                Log.d((String)"bugrpt", (String)("procStat.pid " + procStat.pid + " current pid:" + Process.myPid()));
            }
        } else {
            Log.d((String)"bugrpt", (String)"procStat is null");
        }
    }

    protected Object[] matchPattern(BufferedReader bufferedReader, Pattern ... array) throws IOException {
        String line;
        if (bufferedReader == null || array == null) {
            return null;
        }
        while ((line = bufferedReader.readLine()) != null) {
            for (Pattern pattern : array) {
                if (!pattern.matcher(line).matches()) continue;
                return new Object[]{pattern, line};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean parseTrace(String filePath, TraceUtil tracer) {
        boolean bRet;
        block25: {
            bRet = false;
            if (filePath == null) {
                return false;
            }
            File file = new File(filePath);
            if (!file.exists()) {
                Log.d((String)"bugrpt", (String)("file not exists:" + filePath));
                return false;
            }
            BufferedReader bufferedReader = null;
            try {
                Object[] a3;
                bufferedReader = new BufferedReader(new FileReader(file));
                Pattern startPattern = Pattern.compile("-{5}\\spid\\s\\d+\\sat\\s\\d+-\\d+-\\d+\\s\\d{2}:\\d{2}:\\d{2}\\s-{5}");
                Pattern endPattern = Pattern.compile("-{5}\\send\\s\\d+\\s-{5}");
                Pattern cmdPattern = Pattern.compile("Cmd\\sline:\\s(\\S+)");
                Pattern tidPattern = Pattern.compile("\".+\"\\s(daemon\\s){0,1}prio=\\d+\\stid=\\d+\\s.*");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                Object[] a = this.matchPattern(bufferedReader, startPattern);
                if (a == null) break block25;
                String[] split = a[1].toString().split("\\s");
                long pid = Long.parseLong(split[2]);
                StringBuffer tempStrbuffer = new StringBuffer();
                tempStrbuffer.append(split[4]).append(" ").append(split[5]).toString();
                String date = tempStrbuffer.toString();
                long time = simpleDateFormat.parse(date).getTime();
                Object[] a2 = this.matchPattern(bufferedReader, cmdPattern);
                if (a2 == null) {
                    try {
                        bufferedReader.close();
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException ex2) {
                        boolean ex13;
                        block26: {
                            ex2.printStackTrace();
                            ex13 = false;
                            if (bufferedReader == null) break block26;
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException ex132) {
                                ex132.printStackTrace();
                            }
                        }
                        return ex13;
                    }
                }
                Matcher matcher = cmdPattern.matcher(a2[1].toString());
                matcher.find();
                String cmd = matcher.group(1);
                JSONArray map = new JSONArray();
                while ((a3 = this.matchPattern(bufferedReader, tidPattern, endPattern)) != null && a3[0] == tidPattern) {
                    String line = a3[1].toString();
                    Matcher matcher2 = Pattern.compile("\".+\"").matcher(line);
                    matcher2.find();
                    String group = matcher2.group();
                    String threadName = group.substring(1, group.length() - 1);
                    Matcher matcher3 = Pattern.compile("tid=\\d+").matcher(line);
                    matcher3.find();
                    String subTid = matcher3.group();
                    int tid = Integer.parseInt(subTid.substring(subTid.indexOf("=") + 1));
                    String threadStack = this.getThreadStack(bufferedReader);
                    JSONObject json = new JSONObject();
                    json.put("id", (Object)subTid);
                    json.put("name", (Object)group);
                    json.put("stack", (Object)threadStack);
                    map.put((Object)json);
                }
                if (tracer != null) {
                    tracer.init(time, pid, cmd, map);
                }
                bRet = true;
                break block25;
                {
                    catch (Exception ex9) {
                        Log.d((String)"bugrpt", (String)("exception:" + ex9.toString()));
                        break block25;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex13) {
                        ex13.printStackTrace();
                    }
                }
            }
        }
        return bRet;
    }

    protected String getThreadStack(BufferedReader bufferedReader) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null && line.trim().length() > 0) {
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    private String getAnrReason(ActivityManager.ProcessErrorStateInfo errState) {
        int tag;
        int endPos;
        int idx;
        String strReason = "";
        String processErrorMsg = errState.longMsg;
        if (processErrorMsg != null && (idx = processErrorMsg.indexOf("Reason: ")) != -1 && (endPos = processErrorMsg.indexOf("\n", idx + 1)) != -1) {
            strReason = processErrorMsg.substring(idx + 8, endPos);
        }
        if (strReason.equals("")) {
            strReason = errState.shortMsg;
        }
        if ((tag = strReason.indexOf("(")) != -1) {
            strReason = strReason.substring(0, tag).trim();
        }
        return strReason;
    }

    private ActivityManager.ProcessErrorStateInfo getProcessErrorStateInfo(Context context, long waittime) {
        try {
            if (context != null) {
                ActivityManager am = (ActivityManager)context.getSystemService("activity");
                if (am != null) {
                    long cnt = waittime / 500L;
                    int i = 0;
                    do {
                        List processesInErrorState;
                        if ((processesInErrorState = am.getProcessesInErrorState()) != null) {
                            for (ActivityManager.ProcessErrorStateInfo processErrorStateInfo : processesInErrorState) {
                                if (processErrorStateInfo.condition != 2) continue;
                                Log.d((String)"bugrpt", (String)("found anr process:" + processErrorStateInfo.pid));
                                return processErrorStateInfo;
                            }
                        }
                        Common.sleep(500L);
                    } while ((long)i++ < cnt);
                }
            } else {
                Log.e((String)"bugrpt", (String)"getProcessErrorStateInfo context is null");
            }
        }
        catch (Exception e) {
            Log.e((String)"bugrpt", (String)("error in getProcessErrorStateInfo:" + e.getMessage()));
        }
        return null;
    }

    public class TraceUtil {
        public long time = 0L;
        public long pid = 0L;
        public String processCmd = "";
        JSONArray threadMap = new JSONArray();

        public void init(long t, long p, String cmd, JSONArray map) {
            this.time = t;
            this.pid = p;
            this.processCmd = cmd;
            this.threadMap = map;
        }
    }

    private class THandler
    extends Handler {
        public THandler(Looper loop) {
            super(loop);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    String filePath = (String)msg.obj;
                    Log.d((String)"bugrpt", (String)("begin dealWithANR,path:" + filePath));
                    AnrMonitor.this.dealWithANR(filePath);
                    Log.d((String)"bugrpt", (String)"end dealWithANR");
                    break;
                }
            }
            super.handleMessage(msg);
        }
    }
}

