/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.haha.perflib.ArrayInstance;
import com.squareup.haha.perflib.ClassInstance;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.HahaSpy;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.RootObj;
import com.squareup.haha.perflib.RootType;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.perflib.Type;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.Exclusion;
import com.squareup.leakcanary.HahaHelper;
import com.squareup.leakcanary.LeakNode;
import com.squareup.leakcanary.LeakTraceElement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

final class ShortestPathFinder {
    private final ExcludedRefs excludedRefs;
    private final Deque<LeakNode> toVisitQueue;
    private final Deque<LeakNode> toVisitIfNoPathQueue;
    private final LinkedHashSet<Instance> toVisitSet;
    private final LinkedHashSet<Instance> toVisitIfNoPathSet;
    private final LinkedHashSet<Instance> visitedSet;
    private boolean canIgnoreStrings;

    ShortestPathFinder(ExcludedRefs excludedRefs) {
        this.excludedRefs = excludedRefs;
        this.toVisitQueue = new ArrayDeque<LeakNode>();
        this.toVisitIfNoPathQueue = new ArrayDeque<LeakNode>();
        this.toVisitSet = new LinkedHashSet();
        this.toVisitIfNoPathSet = new LinkedHashSet();
        this.visitedSet = new LinkedHashSet();
    }

    Result findPath(Snapshot snapshot, Instance leakingRef) {
        this.clearState();
        this.canIgnoreStrings = !this.isString(leakingRef);
        this.enqueueGcRoots(snapshot);
        boolean excludingKnownLeaks = false;
        LeakNode leakingNode = null;
        while (!this.toVisitQueue.isEmpty() || !this.toVisitIfNoPathQueue.isEmpty()) {
            LeakNode node;
            if (!this.toVisitQueue.isEmpty()) {
                node = this.toVisitQueue.poll();
            } else {
                node = this.toVisitIfNoPathQueue.poll();
                if (node.exclusion == null) {
                    throw new IllegalStateException("Expected node to have an exclusion " + node);
                }
                excludingKnownLeaks = true;
            }
            if (node.instance == leakingRef) {
                leakingNode = node;
                break;
            }
            if (this.checkSeen(node)) continue;
            if (node.instance instanceof RootObj) {
                this.visitRootObj(node);
                continue;
            }
            if (node.instance instanceof ClassObj) {
                this.visitClassObj(node);
                continue;
            }
            if (node.instance instanceof ClassInstance) {
                this.visitClassInstance(node);
                continue;
            }
            if (node.instance instanceof ArrayInstance) {
                this.visitArrayInstance(node);
                continue;
            }
            throw new IllegalStateException("Unexpected type for " + node.instance);
        }
        return new Result(leakingNode, excludingKnownLeaks);
    }

    private void clearState() {
        this.toVisitQueue.clear();
        this.toVisitIfNoPathQueue.clear();
        this.toVisitSet.clear();
        this.toVisitIfNoPathSet.clear();
        this.visitedSet.clear();
    }

    private void enqueueGcRoots(Snapshot snapshot) {
        block5: for (RootObj rootObj : snapshot.getGCRoots()) {
            switch (rootObj.getRootType()) {
                case JAVA_LOCAL: {
                    Instance thread = HahaSpy.allocatingThread((Instance)rootObj);
                    String threadName = HahaHelper.threadName(thread);
                    Exclusion params = (Exclusion)this.excludedRefs.threadNames.get(threadName);
                    if (params != null && params.alwaysExclude) continue block5;
                    this.enqueue(params, null, (Instance)rootObj, null, null);
                    continue block5;
                }
                case INTERNED_STRING: 
                case DEBUGGER: 
                case INVALID_TYPE: 
                case UNREACHABLE: 
                case UNKNOWN: 
                case FINALIZING: {
                    continue block5;
                }
                case SYSTEM_CLASS: 
                case VM_INTERNAL: 
                case NATIVE_LOCAL: 
                case NATIVE_STATIC: 
                case THREAD_BLOCK: 
                case BUSY_MONITOR: 
                case NATIVE_MONITOR: 
                case REFERENCE_CLEANUP: 
                case NATIVE_STACK: 
                case JAVA_STATIC: {
                    this.enqueue(null, null, (Instance)rootObj, null, null);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown root type:" + rootObj.getRootType());
        }
    }

    private boolean checkSeen(LeakNode node) {
        return !this.visitedSet.add(node.instance);
    }

    private void visitRootObj(LeakNode node) {
        RootObj rootObj = (RootObj)node.instance;
        Instance child = rootObj.getReferredInstance();
        if (rootObj.getRootType() == RootType.JAVA_LOCAL) {
            Instance holder = HahaSpy.allocatingThread((Instance)rootObj);
            Exclusion exclusion = null;
            if (node.exclusion != null) {
                exclusion = node.exclusion;
            }
            LeakNode parent = new LeakNode(null, holder, null, null, null);
            this.enqueue(exclusion, parent, child, "<Java Local>", LeakTraceElement.Type.LOCAL);
        } else {
            this.enqueue(null, node, child, null, null);
        }
    }

    private void visitClassObj(LeakNode node) {
        ClassObj classObj = (ClassObj)node.instance;
        Map ignoredStaticFields = (Map)this.excludedRefs.staticFieldNameByClassName.get(classObj.getClassName());
        for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
            Exclusion params;
            String fieldName;
            Field field = (Field)entry.getKey();
            if (field.getType() != Type.OBJECT || (fieldName = field.getName()).equals("$staticOverhead")) continue;
            Instance child = (Instance)entry.getValue();
            boolean visit = true;
            if (ignoredStaticFields != null && (params = (Exclusion)ignoredStaticFields.get(fieldName)) != null) {
                visit = false;
                if (!params.alwaysExclude) {
                    this.enqueue(params, node, child, fieldName, LeakTraceElement.Type.STATIC_FIELD);
                }
            }
            if (!visit) continue;
            this.enqueue(null, node, child, fieldName, LeakTraceElement.Type.STATIC_FIELD);
        }
    }

    private void visitClassInstance(LeakNode node) {
        ClassInstance classInstance = (ClassInstance)node.instance;
        LinkedHashMap ignoredFields = new LinkedHashMap();
        Exclusion classExclusion = null;
        for (ClassObj superClassObj = classInstance.getClassObj(); superClassObj != null; superClassObj = superClassObj.getSuperClassObj()) {
            Map classIgnoredFields;
            Exclusion params = (Exclusion)this.excludedRefs.classNames.get(superClassObj.getClassName());
            if (!(params == null || classExclusion != null && classExclusion.alwaysExclude)) {
                classExclusion = params;
            }
            if ((classIgnoredFields = (Map)this.excludedRefs.fieldNameByClassName.get(superClassObj.getClassName())) == null) continue;
            ignoredFields.putAll(classIgnoredFields);
        }
        if (classExclusion != null && classExclusion.alwaysExclude) {
            return;
        }
        for (ClassInstance.FieldValue fieldValue : classInstance.getValues()) {
            Exclusion fieldExclusion = classExclusion;
            Field field = fieldValue.getField();
            if (field.getType() != Type.OBJECT) continue;
            Instance child = (Instance)fieldValue.getValue();
            String fieldName = field.getName();
            Exclusion params = (Exclusion)ignoredFields.get(fieldName);
            if (params != null && (fieldExclusion == null || params.alwaysExclude && !fieldExclusion.alwaysExclude)) {
                fieldExclusion = params;
            }
            this.enqueue(fieldExclusion, node, child, fieldName, LeakTraceElement.Type.INSTANCE_FIELD);
        }
    }

    private void visitArrayInstance(LeakNode node) {
        ArrayInstance arrayInstance = (ArrayInstance)node.instance;
        Type arrayType = arrayInstance.getArrayType();
        if (arrayType == Type.OBJECT) {
            Object[] values = arrayInstance.getValues();
            for (int i = 0; i < values.length; ++i) {
                Instance child = (Instance)values[i];
                this.enqueue(null, node, child, "[" + i + "]", LeakTraceElement.Type.ARRAY_ENTRY);
            }
        }
    }

    private void enqueue(Exclusion exclusion, LeakNode parent, Instance child, String referenceName, LeakTraceElement.Type referenceType) {
        boolean visitNow;
        if (child == null) {
            return;
        }
        if (HahaHelper.isPrimitiveOrWrapperArray(child) || HahaHelper.isPrimitiveWrapper(child)) {
            return;
        }
        if (this.toVisitSet.contains(child)) {
            return;
        }
        boolean bl = visitNow = exclusion == null;
        if (!visitNow && this.toVisitIfNoPathSet.contains(child)) {
            return;
        }
        if (this.canIgnoreStrings && this.isString(child)) {
            return;
        }
        if (this.visitedSet.contains(child)) {
            return;
        }
        LeakNode childNode = new LeakNode(exclusion, child, parent, referenceName, referenceType);
        if (visitNow) {
            this.toVisitSet.add(child);
            this.toVisitQueue.add(childNode);
        } else {
            this.toVisitIfNoPathSet.add(child);
            this.toVisitIfNoPathQueue.add(childNode);
        }
    }

    private boolean isString(Instance instance) {
        return instance.getClassObj() != null && instance.getClassObj().getClassName().equals(String.class.getName());
    }

    static final class Result {
        final LeakNode leakingNode;
        final boolean excludingKnownLeaks;

        Result(LeakNode leakingNode, boolean excludingKnownLeaks) {
            this.leakingNode = leakingNode;
            this.excludingKnownLeaks = excludingKnownLeaks;
        }
    }
}

