/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.haha.perflib.ArrayInstance;
import com.squareup.haha.perflib.ClassInstance;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.Type;
import com.squareup.leakcanary.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HahaHelper {
    private static final Set<String> WRAPPER_TYPES = new HashSet<String>(Arrays.asList(Boolean.class.getName(), Character.class.getName(), Float.class.getName(), Double.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName()));

    static String fieldToString(Map.Entry<Field, Object> entry) {
        return HahaHelper.fieldToString(entry.getKey(), entry.getValue());
    }

    static String fieldToString(ClassInstance.FieldValue fieldValue) {
        return HahaHelper.fieldToString(fieldValue.getField(), fieldValue.getValue());
    }

    static String fieldToString(Field field, Object value) {
        return field.getName() + " = " + value;
    }

    static String threadName(Instance holder) {
        List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(holder);
        Object nameField = HahaHelper.fieldValue(values, "name");
        if (nameField == null) {
            return "Thread name not available";
        }
        return HahaHelper.asString(nameField);
    }

    static boolean extendsThread(ClassObj clazz) {
        boolean extendsThread = false;
        ClassObj parentClass = clazz;
        while (parentClass.getSuperClassObj() != null) {
            if (clazz.getClassName().equals(Thread.class.getName())) {
                extendsThread = true;
                break;
            }
            parentClass = parentClass.getSuperClassObj();
        }
        return extendsThread;
    }

    static String asString(Object stringObject) {
        Instance instance = (Instance)stringObject;
        List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(instance);
        Integer count = (Integer)HahaHelper.fieldValue(values, "count");
        Preconditions.checkNotNull((Object)count, (String)"count");
        if (count == 0) {
            return "";
        }
        Object value = HahaHelper.fieldValue(values, "value");
        Preconditions.checkNotNull(value, (String)"value");
        if (HahaHelper.isCharArray(value)) {
            ArrayInstance array = (ArrayInstance)value;
            Integer offset = 0;
            if (HahaHelper.hasField(values, "offset")) {
                offset = (Integer)HahaHelper.fieldValue(values, "offset");
                Preconditions.checkNotNull((Object)offset, (String)"offset");
            }
            char[] chars = array.asCharArray(offset.intValue(), count.intValue());
            return new String(chars);
        }
        if (HahaHelper.isByteArray(value)) {
            ArrayInstance array = (ArrayInstance)value;
            try {
                Method asRawByteArray = ArrayInstance.class.getDeclaredMethod("asRawByteArray", Integer.TYPE, Integer.TYPE);
                asRawByteArray.setAccessible(true);
                byte[] rawByteArray = (byte[])asRawByteArray.invoke((Object)array, 0, count);
                return new String(rawByteArray, Charset.forName("UTF-8"));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("Could not find char array in " + instance);
    }

    public static boolean isPrimitiveWrapper(Object value) {
        if (!(value instanceof ClassInstance)) {
            return false;
        }
        return WRAPPER_TYPES.contains(((ClassInstance)value).getClassObj().getClassName());
    }

    public static boolean isPrimitiveOrWrapperArray(Object value) {
        if (!(value instanceof ArrayInstance)) {
            return false;
        }
        ArrayInstance arrayInstance = (ArrayInstance)value;
        if (arrayInstance.getArrayType() != Type.OBJECT) {
            return true;
        }
        return WRAPPER_TYPES.contains(arrayInstance.getClassObj().getClassName());
    }

    private static boolean isCharArray(Object value) {
        return value instanceof ArrayInstance && ((ArrayInstance)value).getArrayType() == Type.CHAR;
    }

    private static boolean isByteArray(Object value) {
        return value instanceof ArrayInstance && ((ArrayInstance)value).getArrayType() == Type.BYTE;
    }

    static List<ClassInstance.FieldValue> classInstanceValues(Instance instance) {
        ClassInstance classInstance = (ClassInstance)instance;
        return classInstance.getValues();
    }

    static <T> T fieldValue(List<ClassInstance.FieldValue> values, String fieldName) {
        for (ClassInstance.FieldValue fieldValue : values) {
            if (!fieldValue.getField().getName().equals(fieldName)) continue;
            return (T)fieldValue.getValue();
        }
        throw new IllegalArgumentException("Field " + fieldName + " does not exists");
    }

    static boolean hasField(List<ClassInstance.FieldValue> values, String fieldName) {
        for (ClassInstance.FieldValue fieldValue : values) {
            if (!fieldValue.getField().getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private HahaHelper() {
        throw new AssertionError();
    }
}

