<#include "componentFieldItem.ftl" />


<template>
  <div class="model-form">
    <el-page-header @back="goBack" content="增加${model!}">
    </el-page-header>
    <div class="model-content">
      <el-form ref="ruleForm" :rules="rules" :model="form" label-width="160px">
        <el-row :gutter="10">
          <#list bean.fields as item>
            <@fieldItem item />
          </#list>
        </el-row>
        <el-row>
          <el-col :span="24" style="text-align: right;padding-bottom: 20px;padding-top: 20px;">
            <el-button @click="goBack">取消</el-button>
            <el-button type="primary" @click="add">确定</el-button>
          </el-col>
        </el-row>
      </el-form>
    </div>
  </div>
</template>

<script>
  import common from "@/mixins/common.js";
  <#if componentState>
		 <#list components as item>
       import ${item} from "@/components/${item}.vue";
		 </#list>
	</#if>
  var config = {};
  config.methods = {};
  config.mixins = [common];
	<#if componentState>
  config.components={<#list components as item>${item}<#sep></#list>};
  </#if>


	config.data = function () {
			return {
				form: {
					<#list bean.fields as item>
					${item.id!}: ''<#sep>,
					</#list>
				},
        <#list bean.fields as item>
          <#if item.option?length gt 2 >
            ${item.id}Options: [],
          </#if>
        </#list>
				rules: {
					   <#list bean.fields as item>
                <#if item.required>
                        ${item.id}: [
							          { required: true, message: '请输入${item.title!}', trigger: 'blur' }
			                  <#if item.type='money'>
                          , { type: 'number', message: '${item.title!}必须为数字值'}
                        </#if>
						      ]<#sep>,
                </#if>
            </#list>
				}
			}
	};

	<#list bean.fields as item>
            <#if item.type='selectRemote'>
                  config.methods.remote${item.id?cap_first} = function (query) {
                      if (query !== '') { }
                      var self = this;
                      var param = {};
                      param.sortMethod = "asc";
                      param.sortField = "id";
                      param.level = 1;
                      param.size = 500;
                      param.fetch = 0;
                      param.name = query;
                      this.postData("/tenantRest/${item.id}/list.htm", param, function (result) {
                          if (result.code == 0) {
                             self.${item.id}Options= result.list;
                          }
                      });
                  }
            </#if>
    </#list>



  config.methods.add = function () {
			var self = this;
			this.$refs["ruleForm"].validate(function(valid){
				if (valid) {
					self.addData();
				} else {
					console.log('error submit!!');
					return false;
				}
			});
		}

	config.methods.addData = function () {
			var self = this, data = this.form;
			if (this.deforeAddData) {
				this.deforeAddData();
			}
       <#list bean.fields as item>
          <#if item.type='richText'>
              if (ue${item.id}) {
                  data.${item.id} = ue${item.id}.getContent();
              }
          </#if>
      </#list>               
			this.postData("/tenantRest/${config_entity}/create.htm", data, function (res) {
				if (res.code == 0) {
					self.$message({
						message: '添加数据成功',
						type: 'success'
					});
					self.$router.go(-1);
				} else {
					self.$message.error(res.msg);
				}
			});
		}


		<#list bean.fields as item>
		<#if item.option?length gt 2 >
		config.methods.load${item.id?cap_first}Options= function(){
				var self=this;
				var param = {};
				param.sortMethod = "asc";
				param.sortField = "id";
				param.level =1;
				param.size =500;
				param.fetch=0;
				this.postData("/tenantRest/${item.id?lower_case}/list.htm", param, function (result) {
					if (result.code == 0) {
              self.${item.id}Options= result.list;
					}
				});
		}

		</#if>
		</#list>
  
  	config.mounted = function () {
			<#list bean.fields as item>
        <#if item.option?length gt 2 >
         this.load${item.id?cap_first}Options();
        </#if>
      </#list>
		}


  export default config;
</script>

<style scoped>
</style>