package ${base}.data.resource;

import ${base}.api.apis.${entity.simpleName}Api;
import ${base}.api.domain.request.*;
import ${base}.api.domain.response.${entity.simpleName}Response;
import ${base}.api.domain.simple.${entity.simpleName}Simple;
import ${base}.data.mapper.${entity.simpleName}Mapper;
import ${base}.data.entity.${entity.simpleName};
import ${base}.data.convert.${entity.simpleName}ResponseConvert;
import ${base}.data.convert.${entity.simpleName}SimpleConvert;
import ${base}.data.convert.${entity.simpleName}Convert;
import com.he1618.common.mysql.domain.response.PageResponse;
import com.he1618.common.mysql.filter.QueryWrapperUtils;

import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import javax.annotation.Resource;

@Transactional
@Component
public class ${entity.simpleName}Resource implements ${entity.simpleName}Api {

    @Resource
    private ${entity.simpleName}Mapper mapper;

    @Override
    public ${entity.simpleName}Response create(${entity.simpleName}DataRequest request) {
        ${entity.simpleName}Response result = new ${entity.simpleName}Response();

        ${entity.simpleName} bean = new ${entity.simpleName}Convert().apply(request);
        this.mapper.insert(bean);

        return result;
    }

    @Override
    public ${entity.simpleName}Response update(${entity.simpleName}DataRequest request) {
        ${entity.simpleName}Response result = new ${entity.simpleName}Response();
        ${entity.simpleName} bean = mapper.selectById(request.getId());
        if (bean != null) {
            BeanUtils.copyProperties(request, bean);
            mapper.updateById(bean);
        }
        return result;
    }

    @Override
    public ${entity.simpleName}Response delete(${entity.simpleName}DataRequest request) {
        ${entity.simpleName}Response result = new ${entity.simpleName}Response();
        ${entity.simpleName} bean = mapper.selectById(request.getId());
        if (bean != null) {
            mapper.deleteById(bean.getId());
        }
        return result;
    }

    @Override
    public ${entity.simpleName}Response view(${entity.simpleName}DataRequest request) {
        ${entity.simpleName}Response result=new ${entity.simpleName}Response();
        ${entity.simpleName} bean = mapper.selectById(request.getId());
        if (bean != null) {
            result = new ${entity.simpleName}ResponseConvert().apply(bean);
        }
        return result;
    }

    @Override
    public PageResponse<${entity.simpleName}Simple> search(${entity.simpleName}SearchRequest request) {
       return QueryWrapperUtils.search(mapper, request, new ${entity.simpleName}SimpleConvert());
    }
}
