/*
 * @(#) AudioCapture.java 2015. 1.
 *
 * Copyright 2015 Naver Corp. All rights Reserved.
 * Naver PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.naver.speech.clientapi;

import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;

class AudioCapture {

	private final static String TAG = AudioCapture.class.getSimpleName();

	private static final int SAMPLING_FREQ = 16000;
	private static final int AUDIO_READ_SIZE_IN_SHORTS = SAMPLING_FREQ  / 10 * 2; // 200ms
	private static final int AUDIO_RECORD_BUFFER_SIZE_IN_BYTE = 32000;

	private AudioRecord mAudioRecord;
	private short[] mAudioBuffer = new short[AUDIO_READ_SIZE_IN_SHORTS];

	static final int OK    =  0;
	static final int ERROR = -1;

	void beforeStart() throws Exception {
		final int bufferSize = Math.max(AUDIO_RECORD_BUFFER_SIZE_IN_BYTE,
										AudioRecord.getMinBufferSize(SAMPLING_FREQ, AudioFormat.CHANNEL_IN_MONO, AudioFormat.ENCODING_PCM_16BIT));

		mAudioRecord = new AudioRecord(MediaRecorder.AudioSource.VOICE_RECOGNITION,
				SAMPLING_FREQ, AudioFormat.CHANNEL_IN_MONO,
				AudioFormat.ENCODING_PCM_16BIT, bufferSize);

		mAudioRecord.startRecording();
	}

	void beforeFinish() throws Exception {
		mAudioRecord.stop();
		mAudioRecord.release();
	}

	short[] record() throws Exception {
		int readed = mAudioRecord.read(mAudioBuffer, 0, AUDIO_READ_SIZE_IN_SHORTS);
		if(readed < 0) {
			switch (readed) {
			case AudioRecord.ERROR:
				throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR");
			case AudioRecord.ERROR_BAD_VALUE:
				throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR_BAD_VALUE");
			case AudioRecord.ERROR_INVALID_OPERATION:
				throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR_INVALID_OPERATION");
			default:
				throw new AudioCaptureException("AudioRecord.read didn't work : " + readed);
			}
		}
		return mAudioBuffer;
	}
}