/*
 * Decompiled with CFR 0.152.
 */
package com.naver.speech.clientapi;

import android.content.Context;
import android.os.Build;
import com.naver.speech.clientapi.AudioCapture;
import com.naver.speech.clientapi.SpeechConfig;
import com.naver.speech.clientapi.SpeechRecognitionException;
import com.naver.speech.clientapi.SpeechRecognitionListener;
import com.naver.speech.clientapi.SpeechRecognitionResult;
import java.util.ArrayList;

public class SpeechRecognizer {
    protected SpeechRecognitionListener speechRecognitionListener;
    private AudioCapture mAudioCapture = new AudioCapture();
    private static final String CLIENT_LIB_NAME = "NaverspeechJNI";
    private static final String CLIENT_LIB_VER = "1.0.6";
    public static final int ERROR_NETWORK_INITIALIZE = 10;
    public static final int ERROR_NETWORK_FINALIZE = 11;
    public static final int ERROR_NETWORK_READ = 12;
    public static final int ERROR_NETWORK_WRITE = 13;
    public static final int ERROR_NETWORK_NACK = 14;
    public static final int ERROR_PACKET = 15;
    public static final int ERROR_AUDIO_INITIALIZE = 20;
    public static final int ERROR_AUDIO_FINIALIZE = 21;
    public static final int ERROR_AUDIO_RECORD = 22;
    public static final int ERROR_SECURITY = 30;
    public static final int ERROR_NO_REULST = 40;
    public static final int ERROR_TIMEOUT = 41;
    public static final int ERROR_NULL_CLIENT = 42;
    public static final int ERROR_UNKOWN_EVENT = 50;
    public static final int ERROR_VERSION = 60;
    public static final int ERROR_CLIENTINFO = 61;
    public static final int ERROR_SERVER_POOL = 62;
    public static final int ERROR_SESSION_EXPIRED = 63;
    public static final int ERROR_NO_HELLO = 64;
    public static final int ERROR_SPEECH_SIZE_EXCEEDED = 65;
    public static final int ERROR_EXCEED_TIME_LIMIT = 66;
    public static final int ERROR_WRONG_SERVICE_TYPE = 67;
    public static final int ERROR_WRONG_LANGUAGE_TYPE = 68;
    public static final int ERROR_OPENAPI_AUTH = 70;
    public static final int ERROR_QUOTA_OVERFLOW = 71;

    public SpeechRecognizer(Context context, String clientId) throws SpeechRecognitionException {
        String errMsg = SpeechRecognizer.setupJNI(CLIENT_LIB_VER, Build.MODEL, Build.VERSION.RELEASE, clientId, context);
        if (errMsg != null) {
            throw new SpeechRecognitionException(errMsg);
        }
    }

    public void initialize() {
        this.initializeJNI();
    }

    public void release() {
        this.releaseJNI();
    }

    public void setSpeechRecognitionListener(SpeechRecognitionListener callback) {
        this.speechRecognitionListener = callback;
    }

    public boolean selectEPDTypeInHybrid(SpeechConfig.EndPointDetectType epdType) {
        return this.selectEPDTypeInHybridJNI(epdType.toInteger());
    }

    public void stop() {
        if (this.isRunning()) {
            this.sendUserEPDJNI();
        }
    }

    public void cancel() {
        this.stopAudioRecording();
        this.stopListeningJNI();
    }

    public boolean isRunning() {
        return this.isRunningJNI();
    }

    public void recognize(SpeechConfig config) throws SpeechRecognitionException {
        if (this.isRunning()) {
            throw new SpeechRecognitionException("Speech Recognizer is already running");
        }
        if (config.getServiceType() == null) {
            throw new SpeechRecognitionException("ServiceType is null");
        }
        if (config.getLanguageType() == null) {
            throw new SpeechRecognitionException("LanguageType is null");
        }
        if (config.getEndPointDetectType() == null) {
            throw new SpeechRecognitionException("EndPointDetectType is null");
        }
        this.startListeningJNI(config.getServiceType().toInteger(), config.getLanguageType().toInteger(), config.isQuestionDetection(), config.getEndPointDetectType().toInteger());
    }

    private int startAudioRecording() {
        try {
            this.mAudioCapture.beforeStart();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private int stopAudioRecording() {
        try {
            this.mAudioCapture.beforeFinish();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private short[] record() {
        try {
            short[] speech = this.mAudioCapture.record();
            return speech;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void onInactive() {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onInactive();
        }
    }

    protected void onReady() {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onReady();
        }
    }

    protected void onRecord(short[] speech) {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onRecord(speech);
        }
    }

    protected void onPartialResult(String result) {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onPartialResult(result);
        }
    }

    protected void onEndPointDetected() {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onEndPointDetected();
        }
    }

    protected void onResult(Object[] result) {
        if (null != this.speechRecognitionListener) {
            SpeechRecognitionResult speechRecognitionResult = new SpeechRecognitionResult();
            ArrayList<String> results = new ArrayList<String>();
            results.add((String)result[0]);
            results.add((String)result[1]);
            results.add((String)result[2]);
            results.add((String)result[3]);
            results.add((String)result[4]);
            speechRecognitionResult.setResults(results);
            speechRecognitionResult.setGender(Integer.parseInt((String)result[5]));
            this.speechRecognitionListener.onResult(speechRecognitionResult);
        }
    }

    protected void onError(int errorCode) {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onError(errorCode);
        }
    }

    protected void onEndPointDetectTypeSelected(int epdType) {
        if (null != this.speechRecognitionListener) {
            switch (epdType) {
                case 0: {
                    this.speechRecognitionListener.onEndPointDetectTypeSelected(SpeechConfig.EndPointDetectType.AUTO);
                    break;
                }
                case 1: {
                    this.speechRecognitionListener.onEndPointDetectTypeSelected(SpeechConfig.EndPointDetectType.MANUAL);
                    break;
                }
            }
        }
    }

    private static native String setupJNI(String var0, String var1, String var2, String var3, Context var4);

    private native void initializeJNI();

    private native void releaseJNI();

    private native boolean selectEPDTypeInHybridJNI(int var1);

    private native void sendUserEPDJNI();

    private native void startListeningJNI(int var1, int var2, boolean var3, int var4);

    private native void stopListeningJNI();

    private native boolean isRunningJNI();

    static {
        System.loadLibrary("NaverspeechJNI-1.0.6");
    }
}

