/*
 * Decompiled with CFR 0.152.
 */
package com.naver.speech.clientapi;

public class SpeechConfig {
    private ServiceType mServiceType = ServiceType.OPENAPI;
    private LanguageType mLanguageType;
    private EndPointDetectType mEndPointDetectType;
    private boolean mQuestionDetection;

    public SpeechConfig(LanguageType languageType, EndPointDetectType endPointDetectType) {
        this.mLanguageType = languageType;
        this.mQuestionDetection = false;
        this.mEndPointDetectType = endPointDetectType;
    }

    ServiceType getServiceType() {
        return this.mServiceType;
    }

    public LanguageType getLanguageType() {
        return this.mLanguageType;
    }

    public void setLanguageType(LanguageType languageType) {
        this.mLanguageType = languageType;
    }

    public EndPointDetectType getEndPointDetectType() {
        return this.mEndPointDetectType;
    }

    public void setEndPointDetectType(EndPointDetectType endPointDetectType) {
        this.mEndPointDetectType = endPointDetectType;
    }

    boolean isQuestionDetection() {
        return this.mQuestionDetection;
    }

    public static enum EndPointDetectType {
        AUTO(0),
        MANUAL(1),
        HYBRID(2);

        private int epdType;

        private EndPointDetectType(int epdType) {
            this.epdType = epdType;
        }

        public int toInteger() {
            return this.epdType;
        }
    }

    public static enum LanguageType {
        KOREAN(0),
        JAPANESE(1),
        ENGLISH(2),
        CHINESE(3);

        private int languageType;

        private LanguageType(int languageType) {
            this.languageType = languageType;
        }

        int toInteger() {
            return this.languageType;
        }
    }

    public static enum ServiceType {
        OPENAPI(13);

        private int serviceType;

        private ServiceType(int serviceType) {
            this.serviceType = serviceType;
        }

        int toInteger() {
            return this.serviceType;
        }
    }
}

