/*
 * Decompiled with CFR 0.152.
 */
package com.naver.speech.clientapi;

import android.media.AudioRecord;
import com.naver.speech.clientapi.AudioCaptureException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class AudioCapture {
    private static final String TAG = AudioCapture.class.getSimpleName();
    private static final int SAMPLING_FREQ = 16000;
    private static final int AUDIO_READ_SIZE_IN_SHORTS = 3200;
    private static final int AUDIO_READ_SIZE_IN_BYTES = 6400;
    private AudioRecord audioRecord;
    private short[] audioBuffer = new short[3200];
    private byte[] audioByteBuffer = new byte[6400];
    private int recordedAudioBufferSize = 0;
    private boolean isAudioFileInput = false;
    private String mAudioFilePath = "";
    private File mFile;
    private FileInputStream mInputStream;
    static final int OK = 0;
    static final int ERROR = -1;

    AudioCapture() {
    }

    void setAudioRecord(AudioRecord audioRecord) {
        this.audioRecord = audioRecord;
    }

    void beforeStart() throws IllegalArgumentException, IllegalStateException, NullPointerException, FileNotFoundException, Exception {
        this.recordedAudioBufferSize = 0;
        if (!this.isAudioFileInput) {
            this.audioRecord = new AudioRecord(6, 16000, 16, 2, 320000);
            this.audioRecord.startRecording();
        } else {
            this.mFile = new File(this.mAudioFilePath);
            this.mInputStream = new FileInputStream(this.mFile);
        }
    }

    void beforeFinish() throws IllegalStateException, IOException, Exception {
        if (!this.isAudioFileInput) {
            this.audioRecord.stop();
            this.audioRecord.release();
        } else {
            this.mInputStream.close();
        }
    }

    short[] record() throws AudioCaptureException, IOException, BufferUnderflowException, InterruptedException {
        if (!this.isAudioFileInput) {
            int readed = this.audioRecord.read(this.audioBuffer, 0, 3200);
            if (readed < 0) {
                switch (readed) {
                    case -1: {
                        throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR");
                    }
                    case -2: {
                        throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR_BAD_VALUE");
                    }
                    case -3: {
                        throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR_INVALID_OPERATION");
                    }
                }
                throw new AudioCaptureException("AudioRecord.read didn't work : " + readed);
            }
            this.recordedAudioBufferSize += readed;
        } else if (this.mInputStream.available() > 0) {
            int readed = this.mInputStream.read(this.audioByteBuffer, 0, 6400);
            if (readed < 0) {
                throw new AudioCaptureException("FileInputStream.read didn't work");
            }
            ByteBuffer.wrap(this.audioByteBuffer).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.audioBuffer);
            this.recordedAudioBufferSize += readed / 2;
        } else {
            return null;
        }
        return this.audioBuffer;
    }

    int getRecoredAudioBufferSize() {
        return this.recordedAudioBufferSize;
    }

    public boolean isAudioFileInput() {
        return this.isAudioFileInput;
    }

    public void setAudioFileInput(boolean isAudioFileInput) {
        this.isAudioFileInput = isAudioFileInput;
    }

    public String getAudioFilePath() {
        return this.mAudioFilePath;
    }

    public void setAudioFilePath(String audioFilePath) {
        this.mAudioFilePath = audioFilePath;
    }
}

