(ns couchdb.errors)

(defrecord InvalidDatabaseName [database])

(defrecord DatabaseNotFound [e])

(defrecord DocumentNotFound [e])

(defrecord AttachmentNotFound [e]) 

;"Raised when a 409 code is returned from the server."
(defrecord ResourceConflict [e])

;"Raised when a 412 code is returned from the server."
(defrecord PreconditionFailed [e]) 

;"Raised when any unexpected code >= 400 is returned from the server."
(defrecord ServerError [e])
 
