package ir.najva.najvasdk.reactnativeplugin;

import android.util.Log;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.najva.najvasdk.Class.Najva;
import com.najva.najvasdk.Class.NajvaJsonDataListener;
import com.najva.najvasdk.Class.NajvaUserHandler;

import javax.annotation.Nonnull;

public class InitializeModule  extends ReactContextBaseJavaModule {

    private static final String TAG = "InitializeModule";
    private static final String HANDLER_EVENT_NAME = "userHandler";
    private static final String DATA_EVENT_NAME = "data";

    private ReactApplicationContext reactContext;

    public InitializeModule(@Nonnull ReactApplicationContext reactContext) {
        super(reactContext);

        this.reactContext = reactContext;
    }

    @Nonnull
    @Override
    public String getName() {
        return "NajvaModule";
    }

    @ReactMethod
    public void initializeNajva(int campaignId,int websiteId,String apiKey){

        Najva.initialize(getCurrentActivity(),campaignId,websiteId,apiKey);
        Log.i(TAG, "apiKey: " + apiKey);

        Najva.setUserHandler(new NajvaUserHandler(){
            @Override
            public void najvaUserSubscribed(String token) {
                reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)
                        .emit(HANDLER_EVENT_NAME,token);
            }
        });
        Najva.setJsonDataListener(new NajvaJsonDataListener() {
            @Override
            public void onReceiveJson(String s) {
                reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)
                        .emit(DATA_EVENT_NAME,s);
            }
        });
    }



}
