/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.mongodb;

import com.google.common.collect.Sets;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mysema.query.mongodb.MongodbOps;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Visitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public abstract class MongodbSerializer
implements Visitor<Object, Void> {
    public Object handle(Expression<?> expression) {
        return expression.accept((Visitor)this, null);
    }

    public DBObject toSort(List<OrderSpecifier<?>> orderBys) {
        BasicDBObject sort = new BasicDBObject();
        for (OrderSpecifier<?> orderBy : orderBys) {
            Object key = orderBy.getTarget().accept((Visitor)this, null);
            sort.append(key.toString(), (Object)(orderBy.getOrder() == Order.ASC ? 1 : -1));
        }
        return sort;
    }

    public Object visit(Constant<?> expr, Void context) {
        if (Enum.class.isAssignableFrom(expr.getType())) {
            return ((Enum)expr.getConstant()).name();
        }
        return expr.getConstant();
    }

    public Object visit(TemplateExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(FactoryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    private String asDBKey(Operation<?> expr, int index) {
        return (String)this.asDBValue(expr, index);
    }

    private Object asDBValue(Operation<?> expr, int index) {
        return expr.getArg(index).accept((Visitor)this, null);
    }

    private String regexValue(Operation<?> expr, int index) {
        return Pattern.quote(expr.getArg(index).accept((Visitor)this, null).toString());
    }

    protected DBObject asDBObject(String key, Object value) {
        return new BasicDBObject(key, value);
    }

    public Object visit(Operation<?> expr, Void context) {
        Operator op = expr.getOperator();
        if (op == Ops.EQ) {
            if (expr.getArg(0) instanceof Operation) {
                Operation lhs = (Operation)expr.getArg(0);
                if (lhs.getOperator() == Ops.COL_SIZE || lhs.getOperator() == Ops.ARRAY_SIZE) {
                    return this.asDBObject(this.asDBKey(lhs, 0), this.asDBObject("$size", this.asDBValue(expr, 1)));
                }
                throw new UnsupportedOperationException("Illegal operation " + expr);
            }
            if (this.isReference(expr, 0)) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asReference(expr, 1));
            }
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBValue(expr, 1));
        }
        if (op == Ops.STRING_IS_EMPTY) {
            return this.asDBObject(this.asDBKey(expr, 0), "");
        }
        if (op == Ops.AND) {
            BSONObject lhs = (BSONObject)this.handle(expr.getArg(0));
            BSONObject rhs = (BSONObject)this.handle(expr.getArg(1));
            if (Sets.intersection((Set)lhs.keySet(), (Set)rhs.keySet()).isEmpty()) {
                lhs.putAll(rhs);
                return lhs;
            }
            BasicDBList list = new BasicDBList();
            list.add(this.handle(expr.getArg(0)));
            list.add(this.handle(expr.getArg(1)));
            return this.asDBObject("$and", list);
        }
        if (op == Ops.NOT) {
            BasicDBObject arg = (BasicDBObject)this.handle(expr.getArg(0));
            String key = (String)arg.keySet().iterator().next();
            Operation subOperation = (Operation)expr.getArg(0);
            Operator subOp = subOperation.getOperator();
            if (subOp == Ops.IN) {
                return this.visit(OperationImpl.create(Boolean.class, (Operator)Ops.NOT_IN, (Expression)subOperation.getArg(0), (Expression)subOperation.getArg(1)), context);
            }
            if (subOp != Ops.EQ && subOp != Ops.STRING_IS_EMPTY) {
                return this.asDBObject(key, this.asDBObject("$not", arg.get(key)));
            }
            return this.asDBObject(key, this.asDBObject("$ne", arg.get(key)));
        }
        if (op == Ops.OR) {
            BasicDBList list = new BasicDBList();
            list.add(this.handle(expr.getArg(0)));
            list.add(this.handle(expr.getArg(1)));
            return this.asDBObject("$or", list);
        }
        if (op == Ops.NE) {
            if (this.isReference(expr, 0)) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$ne", this.asReference(expr, 1)));
            }
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$ne", this.asDBValue(expr, 1)));
        }
        if (op == Ops.STARTS_WITH) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile("^" + this.regexValue(expr, 1)));
        }
        if (op == Ops.STARTS_WITH_IC) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile("^" + this.regexValue(expr, 1), 2));
        }
        if (op == Ops.ENDS_WITH) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.regexValue(expr, 1) + "$"));
        }
        if (op == Ops.ENDS_WITH_IC) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.regexValue(expr, 1) + "$", 2));
        }
        if (op == Ops.EQ_IGNORE_CASE) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile("^" + this.regexValue(expr, 1) + "$", 2));
        }
        if (op == Ops.STRING_CONTAINS) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(".*" + this.regexValue(expr, 1) + ".*"));
        }
        if (op == Ops.STRING_CONTAINS_IC) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(".*" + this.regexValue(expr, 1) + ".*", 2));
        }
        if (op == Ops.MATCHES) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.asDBValue(expr, 1).toString()));
        }
        if (op == Ops.MATCHES_IC) {
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.asDBValue(expr, 1).toString(), 2));
        }
        if (op == Ops.LIKE) {
            String regex = ExpressionUtils.likeToRegex((Expression)expr.getArg(1)).toString();
            return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(regex));
        }
        if (op == Ops.BETWEEN) {
            BasicDBObject value = new BasicDBObject("$gte", this.asDBValue(expr, 1));
            value.append("$lte", this.asDBValue(expr, 2));
            return this.asDBObject(this.asDBKey(expr, 0), value);
        }
        if (op == Ops.IN) {
            int constIndex = 0;
            int exprIndex = 1;
            if (expr.getArg(1) instanceof Constant) {
                constIndex = 1;
                exprIndex = 0;
            }
            if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBObject("$in", values.toArray()));
            }
            if (this.isReference(expr, exprIndex)) {
                return this.asDBObject(this.asDBKey(expr, exprIndex), this.asReference(expr, constIndex));
            }
            return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBValue(expr, constIndex));
        }
        if (op == Ops.NOT_IN) {
            int constIndex = 0;
            int exprIndex = 1;
            if (expr.getArg(1) instanceof Constant) {
                constIndex = 1;
                exprIndex = 0;
            }
            if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBObject("$nin", values.toArray()));
            }
            if (this.isReference(expr, exprIndex)) {
                return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBObject("$ne", this.asReference(expr, constIndex)));
            }
            return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBObject("$ne", this.asDBValue(expr, constIndex)));
        }
        if (op == Ops.COL_IS_EMPTY) {
            BasicDBList list = new BasicDBList();
            list.add((Object)this.asDBObject(this.asDBKey(expr, 0), new BasicDBList()));
            list.add((Object)this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$exists", false)));
            return this.asDBObject("$or", list);
        }
        if (op == Ops.LT) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$lt", this.asDBValue(expr, 1)));
        }
        if (op == Ops.GT) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$gt", this.asDBValue(expr, 1)));
        }
        if (op == Ops.LOE) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$lte", this.asDBValue(expr, 1)));
        }
        if (op == Ops.GOE) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$gte", this.asDBValue(expr, 1)));
        }
        if (op == Ops.IS_NULL) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$exists", false));
        }
        if (op == Ops.IS_NOT_NULL) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$exists", true));
        }
        if (op == Ops.CONTAINS_KEY) {
            Path path = (Path)expr.getArg(0);
            Expression key = expr.getArg(1);
            return this.asDBObject(this.visit(path, context) + "." + key.toString(), this.asDBObject("$exists", true));
        }
        if (op == MongodbOps.NEAR) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$near", this.asDBValue(expr, 1)));
        }
        if (op == MongodbOps.ELEM_MATCH) {
            return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$elemMatch", this.asDBValue(expr, 1)));
        }
        throw new UnsupportedOperationException("Illegal operation " + expr);
    }

    protected DBRef asReference(Operation<?> expr, int constIndex) {
        return this.asReference(((Constant)expr.getArg(constIndex)).getConstant());
    }

    protected DBRef asReference(Object constant) {
        throw new UnsupportedOperationException();
    }

    protected boolean isReference(Operation<?> expr, int exprIndex) {
        Expression arg = expr.getArg(exprIndex);
        if (arg instanceof Path) {
            return this.isReference((Path)arg);
        }
        return false;
    }

    protected boolean isReference(Path<?> arg) {
        return false;
    }

    public String visit(Path<?> expr, Void context) {
        PathMetadata metadata = expr.getMetadata();
        if (metadata.getParent() != null) {
            if (metadata.getPathType() == PathType.COLLECTION_ANY) {
                return this.visit(metadata.getParent(), context);
            }
            if (metadata.getParent().getMetadata().getPathType() != PathType.VARIABLE) {
                String rv = this.getKeyForPath(expr, metadata);
                return this.visit(metadata.getParent(), context) + "." + rv;
            }
        }
        return this.getKeyForPath(expr, metadata);
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata<?> metadata) {
        if (expr.getType().equals(ObjectId.class)) {
            return "_id";
        }
        return metadata.getElement().toString();
    }

    public Object visit(SubQueryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(ParamExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }
}

