/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.google.common.base.Function;
import com.mysema.query.collections.GuavaHelpers;
import com.mysema.query.types.Path;
import java.util.Comparator;

public class PathComparator<T, V extends Comparable<V>>
implements Comparator<T> {
    private final Function<T, V> accessor;

    public PathComparator(Path<V> comparingPath) {
        this(comparingPath, GuavaHelpers.wrap(comparingPath));
    }

    public PathComparator(Path<V> comparingPath, Function<T, V> accessor) {
        this.accessor = accessor;
    }

    public static <T, V extends Comparable<V>> PathComparator<T, V> pathComparator(Path<V> comparingPath) {
        return new PathComparator<T, V>(comparingPath);
    }

    @Override
    public int compare(T leftBean, T rightBean) {
        if (leftBean == rightBean) {
            return 0;
        }
        if (leftBean == null) {
            return -1;
        }
        if (rightBean == null) {
            return 1;
        }
        if (leftBean.equals(rightBean)) {
            return 0;
        }
        return this.comparePathValues(leftBean, rightBean);
    }

    private int comparePathValues(T leftBean, T rightBean) {
        Comparable left = (Comparable)this.accessor.apply(leftBean);
        Comparable right = (Comparable)this.accessor.apply(rightBean);
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }
}

