/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.google.common.collect.Iterators;
import com.mysema.codegen.Evaluator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.collections.DefaultEvaluatorFactory;
import com.mysema.query.collections.EvaluatorFunction;
import com.mysema.query.collections.MultiComparator;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.types.ArrayConstructorExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultQueryEngine
implements QueryEngine {
    private final DefaultEvaluatorFactory evaluatorFactory;

    public DefaultQueryEngine(DefaultEvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    @Override
    public long count(QueryMetadata metadata, Map<Expression<?>, Iterable<?>> iterables) {
        if (metadata.getJoins().size() == 1) {
            return this.evaluateSingleSource(metadata, iterables, true).size();
        }
        return this.evaluateMultipleSources(metadata, iterables, true).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(QueryMetadata metadata, Map<Expression<?>, Iterable<?>> iterables) {
        QueryModifiers modifiers = metadata.getModifiers();
        metadata.setLimit(Long.valueOf(1L));
        try {
            if (metadata.getJoins().size() == 1) {
                boolean bl = !this.evaluateSingleSource(metadata, iterables, true).isEmpty();
                return bl;
            }
            boolean bl = !this.evaluateMultipleSources(metadata, iterables, true).isEmpty();
            return bl;
        }
        finally {
            metadata.setModifiers(modifiers);
        }
    }

    @Override
    public <T> List<T> list(QueryMetadata metadata, Map<Expression<?>, Iterable<?>> iterables, Expression<T> projection) {
        if (metadata.getJoins().size() == 1) {
            return this.evaluateSingleSource(metadata, iterables, false);
        }
        return this.evaluateMultipleSources(metadata, iterables, false);
    }

    private <T> List<T> distinct(List<T> list) {
        ArrayList<T> rv = new ArrayList<T>(list.size());
        if (!list.isEmpty() && list.get(0).getClass().isArray()) {
            HashSet<List<Object>> set = new HashSet<List<Object>>(list.size());
            for (T o : list) {
                if (!set.add(Arrays.asList((Object[])o))) continue;
                rv.add(o);
            }
            return rv;
        }
        for (T o : list) {
            if (rv.contains(o)) continue;
            rv.add(o);
        }
        return rv;
    }

    private List evaluateMultipleSources(QueryMetadata metadata, Map<Expression<?>, Iterable<?>> iterables, boolean count) {
        Evaluator<List<Object[]>> ev = this.evaluatorFactory.createEvaluator(metadata, metadata.getJoins(), metadata.getWhere());
        ArrayList iterableList = new ArrayList(metadata.getJoins().size());
        for (JoinExpression join : metadata.getJoins()) {
            if (join.getType() != JoinType.DEFAULT) continue;
            iterableList.add(iterables.get(join.getTarget()));
        }
        List<?> list = (List<?>)ev.evaluate(iterableList.toArray());
        if (!count && !list.isEmpty()) {
            ArrayList sources = new ArrayList();
            for (JoinExpression join : metadata.getJoins()) {
                if (join.getType() == JoinType.DEFAULT) {
                    sources.add(join.getTarget());
                    continue;
                }
                Operation target = (Operation)join.getTarget();
                sources.add(target.getArg(1));
            }
            if (!metadata.getOrderBy().isEmpty()) {
                this.order(metadata, sources, list);
            }
            if (metadata.getModifiers().isRestricting()) {
                list = metadata.getModifiers().subList(list);
            }
            if (list.isEmpty()) {
                return list;
            }
            list = this.project(metadata, sources, list);
        }
        if (metadata.isDistinct()) {
            list = this.distinct(list);
        }
        return list;
    }

    private List evaluateSingleSource(QueryMetadata metadata, Map<Expression<?>, Iterable<?>> iterables, boolean count) {
        Expression source = ((JoinExpression)metadata.getJoins().get(0)).getTarget();
        List<Expression<?>> sources = Collections.singletonList(source);
        Iterable<?> iterable = iterables.values().iterator().next();
        List<Object> list = iterable instanceof List ? (List<?>)iterable : IteratorAdapter.asList(iterable.iterator());
        if (metadata.getWhere() != null) {
            Evaluator evaluator = this.evaluatorFactory.createEvaluator(metadata, source, metadata.getWhere());
            list = (List<?>)evaluator.evaluate(new Object[]{list});
        }
        if (!count && !list.isEmpty()) {
            if (!metadata.getOrderBy().isEmpty()) {
                if (list == iterable) {
                    list = new ArrayList(list);
                }
                this.order(metadata, sources, list);
            }
            if (metadata.getModifiers().isRestricting()) {
                list = metadata.getModifiers().subList(list);
            }
            if (list.isEmpty()) {
                return list;
            }
            if (metadata.getProjection().size() > 1 || !((Expression)metadata.getProjection().get(0)).equals(source)) {
                list = this.project(metadata, sources, list);
            }
        }
        if (metadata.isDistinct()) {
            list = this.distinct(list);
        }
        return list;
    }

    private void order(QueryMetadata metadata, List<Expression<?>> sources, List<?> list) {
        List orderBy = metadata.getOrderBy();
        Expression[] orderByExpr = new Expression[orderBy.size()];
        boolean[] directions = new boolean[orderBy.size()];
        for (int i = 0; i < orderBy.size(); ++i) {
            orderByExpr[i] = ((OrderSpecifier)orderBy.get(i)).getTarget();
            directions[i] = ((OrderSpecifier)orderBy.get(i)).getOrder() == Order.ASC;
        }
        ArrayConstructorExpression expr = new ArrayConstructorExpression(Object[].class, orderByExpr);
        Evaluator orderEvaluator = this.evaluatorFactory.create(metadata, (List<? extends Expression<?>>)sources, expr);
        Collections.sort(list, new MultiComparator(orderEvaluator, directions));
    }

    private List<?> project(QueryMetadata metadata, List<Expression<?>> sources, List<?> list) {
        Evaluator projectionEvaluator = this.evaluatorFactory.create(metadata, sources, (Expression)metadata.getProjection().get(0));
        EvaluatorFunction transformer = new EvaluatorFunction(projectionEvaluator);
        ArrayList target = new ArrayList();
        Iterators.addAll(target, (Iterator)Iterators.transform(list.iterator(), transformer));
        return target;
    }
}

