/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.query.collections.ColQuery;
import com.mysema.query.collections.ColQueryImpl;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.util.BeanMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColUpdateClause<T>
implements UpdateClause<ColUpdateClause<T>> {
    private final Path<T> expr;
    private final Map<Path<?>, Object> paths = new HashMap();
    private final ColQuery query;

    public ColUpdateClause(QueryEngine qe, Path<T> expr, Iterable<? extends T> col) {
        this.query = (ColQuery)new ColQueryImpl(qe).from(expr, col);
        this.expr = expr;
    }

    public ColUpdateClause(Path<T> expr, Iterable<? extends T> col) {
        this(QueryEngine.DEFAULT, expr, col);
    }

    public long execute() {
        int rv = 0;
        for (Object match : this.query.list((Expression)this.expr)) {
            BeanMap beanMap = new BeanMap(match);
            for (Map.Entry<Path<?>, Object> entry : this.paths.entrySet()) {
                String propertyName = entry.getKey().getMetadata().getExpression().toString();
                beanMap.put(propertyName, entry.getValue());
            }
            ++rv;
        }
        return rv;
    }

    public <U> ColUpdateClause<T> set(Path<U> path, U value) {
        this.paths.put(path, value);
        return this;
    }

    public <U> ColUpdateClause<T> set(Path<U> path, Expression<? extends U> expression) {
        throw new UnsupportedOperationException();
    }

    public <U> ColUpdateClause<T> setNull(Path<U> path) {
        this.paths.put(path, null);
        return this;
    }

    public ColUpdateClause<T> set(List<? extends Path<?>> p, List<?> v) {
        for (int i = 0; i < p.size(); ++i) {
            this.paths.put(p.get(i), v.get(i));
        }
        return this;
    }

    public ColUpdateClause<T> where(Predicate ... o) {
        this.query.where(o);
        return this;
    }

    public String toString() {
        return "update " + this.query;
    }
}

