/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.SearchResults;
import com.mysema.query.collections.ColQueryMixin;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.types.ArrayConstructorExpression;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractColQuery<Q extends AbstractColQuery<Q>>
extends ProjectableQuery<Q> {
    private final Map<Expression<?>, Iterable<?>> iterables = new HashMap();
    private final QueryEngine queryEngine;

    public AbstractColQuery(QueryMetadata metadata, QueryEngine queryEngine) {
        super(new ColQueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
        this.queryEngine = queryEngine;
    }

    public long count() {
        try {
            long l = this.queryEngine.count(this.getMetadata(), this.iterables);
            return l;
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    public boolean exists() {
        try {
            boolean bl = this.queryEngine.exists(this.getMetadata(), this.iterables);
            return bl;
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <D> Expression<D> createAlias(CollectionExpression<?, D> target, Path<D> alias) {
        return OperationImpl.create((Class)alias.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{target, alias});
    }

    private <D> Expression<D> createAlias(MapExpression<?, D> target, Path<D> alias) {
        return OperationImpl.create((Class)alias.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{target, alias});
    }

    public <A> Q from(Path<A> entity, Iterable<? extends A> col) {
        this.iterables.put((Expression<?>)entity, col);
        this.getMetadata().addJoin(JoinType.DEFAULT, entity);
        return (Q)((Object)this);
    }

    public <A> Q bind(Path<A> entity, Iterable<? extends A> col) {
        this.iterables.put((Expression<?>)entity, col);
        return (Q)((Object)this);
    }

    public abstract QueryMetadata getMetadata();

    protected QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public <P> Q innerJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public <P> Q innerJoin(MapExpression<?, P> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return this.iterate((Expression)new ArrayConstructorExpression(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        try {
            projection = this.queryMixin.convert(projection);
            this.queryMixin.addToProjection(new Expression[]{projection});
            IteratorAdapter iteratorAdapter = new IteratorAdapter(this.queryEngine.list(this.getMetadata(), this.iterables, projection).iterator());
            return iteratorAdapter;
        }
        finally {
            this.reset();
        }
    }

    public List<Object[]> list(Expression<?>[] args) {
        return this.list((Expression)new ArrayConstructorExpression(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> List<RT> list(Expression<RT> projection) {
        try {
            projection = this.queryMixin.convert(projection);
            this.queryMixin.addToProjection(new Expression[]{projection});
            List list = this.queryEngine.list(this.getMetadata(), this.iterables, projection);
            return list;
        }
        finally {
            this.reset();
        }
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        projection = this.queryMixin.convert(projection);
        this.queryMixin.addToProjection(new Expression[]{projection});
        long count = this.queryEngine.count(this.getMetadata(), this.iterables);
        if (count > 0L) {
            List list = this.queryEngine.list(this.getMetadata(), this.iterables, projection);
            this.reset();
            return new SearchResults(list, this.getMetadata().getModifiers(), count);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    public Object[] uniqueResult(Expression<?>[] args) {
        this.queryMixin.setUnique(true);
        if (this.queryMixin.getMetadata().getModifiers().getLimit() == null) {
            this.limit(2L);
        }
        return (Object[])this.uniqueResult(this.iterate(args));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.queryMixin.setUnique(true);
        if (this.queryMixin.getMetadata().getModifiers().getLimit() == null) {
            this.limit(2L);
        }
        return (RT)this.uniqueResult(this.iterate(expr));
    }

    private void reset() {
        this.getMetadata().reset();
    }
}

