/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.SearchResults;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.EArrayConstructor;
import com.mysema.query.types.expr.OSimple;
import com.mysema.query.types.path.PMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractColQuery<Q extends AbstractColQuery<Q>>
extends ProjectableQuery<Q> {
    private final Map<Expr<?>, Iterable<?>> iterables = new HashMap();
    private final QueryEngine queryEngine;

    public AbstractColQuery(QueryMetadata metadata, QueryEngine queryEngine) {
        super(new QueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
        this.queryEngine = queryEngine;
    }

    public long count() {
        try {
            long l = this.queryEngine.count(this.getMetadata(), this.iterables);
            return l;
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <D> Expr<D> createAlias(Path<? extends Collection<D>> target, Path<D> alias) {
        return OSimple.create((Class)alias.getType(), (Operator)Ops.ALIAS, (Expr[])new Expr[]{target.asExpr(), alias.asExpr()});
    }

    private <D> Expr<D> createAlias(PMap<?, D, ?> target, Path<D> alias) {
        return OSimple.create((Class)alias.getType(), (Operator)Ops.ALIAS, (Expr[])new Expr[]{target.asExpr(), alias.asExpr()});
    }

    public <A> Q from(Path<A> entity, Iterable<? extends A> col) {
        this.iterables.put(entity.asExpr(), col);
        this.getMetadata().addJoin(JoinType.DEFAULT, entity.asExpr());
        return (Q)((Object)this);
    }

    public abstract QueryMetadata getMetadata();

    protected QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public <P> Q innerJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public <P> Q innerJoin(PMap<?, P, ?> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)this);
    }

    public CloseableIterator<Object[]> iterate(Expr<?>[] args) {
        return this.iterate((Expr)new EArrayConstructor(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> CloseableIterator<RT> iterate(Expr<RT> projection) {
        try {
            this.queryMixin.addToProjection(new Expr[]{projection});
            IteratorAdapter iteratorAdapter = new IteratorAdapter(this.queryEngine.list(this.getMetadata(), this.iterables, projection).iterator());
            return iteratorAdapter;
        }
        finally {
            this.reset();
        }
    }

    public List<Object[]> list(Expr<?>[] args) {
        return this.list((Expr)new EArrayConstructor(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> List<RT> list(Expr<RT> projection) {
        try {
            this.queryMixin.addToProjection(new Expr[]{projection});
            List<RT> list = this.queryEngine.list(this.getMetadata(), this.iterables, projection);
            return list;
        }
        finally {
            this.reset();
        }
    }

    public <RT> SearchResults<RT> listResults(Expr<RT> projection) {
        this.queryMixin.addToProjection(new Expr[]{projection});
        long count = this.queryEngine.count(this.getMetadata(), this.iterables);
        if (count > 0L) {
            List<RT> list = this.queryEngine.list(this.getMetadata(), this.iterables, projection);
            this.reset();
            return new SearchResults(list, this.getMetadata().getModifiers(), count);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    private void reset() {
        this.getMetadata().reset();
    }
}

