/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections.impl;

import com.mysema.query.collections.impl.ArrayTransformer;
import com.mysema.query.collections.impl.Evaluator;
import com.mysema.query.collections.impl.EvaluatorFactory;
import com.mysema.query.collections.impl.EvaluatorPredicate;
import com.mysema.query.collections.impl.EvaluatorTransformer;
import com.mysema.query.collections.impl.SingleArgEvaluatorPredicate;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections15.IteratorUtils;

@Immutable
public class IteratorFactory {
    private final EvaluatorFactory evaluatorFactory;

    public IteratorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    public <S> Iterator<S> multiArgFilter(Iterator<S> source, List<Expr<?>> sources, EBoolean condition) {
        Evaluator<Boolean> ev = this.evaluatorFactory.create((List<? extends Expr<?>>)sources, condition);
        return this.multiArgFilter(source, ev);
    }

    private <S> Iterator<S> multiArgFilter(Iterator<S> source, Evaluator<Boolean> ev) {
        return IteratorUtils.filteredIterator(source, new EvaluatorPredicate(ev));
    }

    public <S, T> Iterator<T> transform(Iterator<S> source, List<Expr<?>> sources, Expr<T> projection) {
        Evaluator<T> ev = this.evaluatorFactory.create(sources, projection);
        return this.transform(source, ev);
    }

    private <S, T> Iterator<T> transform(Iterator<S> source, Evaluator<T> ev) {
        return IteratorUtils.transformedIterator(source, new EvaluatorTransformer(ev));
    }

    public <S> Iterator<S> singleArgFilter(Iterator<S> source, Evaluator<Boolean> ev) {
        return IteratorUtils.filteredIterator(source, new SingleArgEvaluatorPredicate(ev));
    }

    public <S> Iterator<S[]> toArrayIterator(Iterator<S> source) {
        return IteratorUtils.transformedIterator(source, new ArrayTransformer());
    }
}

